namespace AddisonWesley.Michaelis.EssentialCSharp.Chapter12.Listing12_22
{
    using System;
    using Listing12_13;

    public class BinaryTree<T>
        where T : System.IComparable<T>
    {
        public T Item { get; set; }

        public Pair<BinaryTree<T>> SubItems
        {
            get { return _SubItems; }
            set
            {
                IComparable<T> first;
                // Zauwa, e teraz mona pomin rzutowanie.
                first = value.First.Item;

                if(first.CompareTo(value.Second.Item) < 0)
                {
        // Warto waciwoci First jest mniejsza ni warto waciwoci Second.
        // ...
      }
                else
                {
                    // Warto waciwoci Second jest mniejsza lub rwna wzgldem waciwoci First.
                    //...
                }
                _SubItems = value;
            }
        }
        private Pair<BinaryTree<T>> _SubItems;

    }
}
