﻿using System.Diagnostics;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.IO;

namespace Protokoly
{
   class Program
   {
      static void Main(string[] args)
      {
         // zapisuj do pliku tekstowego w folderze projektu
         Trace.Listeners.Add(new TextWriterTraceListener(File.CreateText("log.txt")));

         // zapisywanie tekstu jest buforowane, a ta opcja wywołuje
         // metodę Flush() we wszystkich obiektach nasłuchujących
         // po wykonaniu każdego zapisu
         Trace.AutoFlush = true;

         Debug.WriteLine("Typ Debug mówi, że już jest gotowy!");
         Trace.WriteLine("Typ Trace mówi, że już jest gotowy!");

         var ts = new TraceSwitch("Przelacznik", "Ten przelacznik sterowany jest parametrem wiersza polecen.");

         if (args.Length > 0)
         {
            if (System.Enum.TryParse<TraceLevel>(args[0],
              ignoreCase: true, result: out TraceLevel level))
            {
               ts.Level = level;
            }
         }

         Trace.WriteLineIf(ts.TraceError, "Poziom błędow");
         Trace.WriteLineIf(ts.TraceWarning, "Poziom ostrzeżeń");
         Trace.WriteLineIf(ts.TraceInfo, "Poziom informacji");
         Trace.WriteLineIf(ts.TraceVerbose, "Poziom ogólny");
      }
   }
}
