﻿using Microsoft.AspNetCore.Mvc;
using CS7;
using System.Collections.Generic;
using System.Linq;

namespace SerwisNorthwind.Controllers
{
   [Route("api/[controller]")]
   public class ProduktyController : Controller
   {
      private readonly Northwind bd;

      public ProduktyController(Northwind bd)
      {
         this.bd = bd;
      }

      // GET: api/produkty
      [HttpGet]
      public IEnumerable<Product> Odczytaj()
      {
         var produkty = bd.Products.ToArray();
         return produkty;
      }

      // GET api/produkty/5
      [HttpGet("{id}")]
      public IEnumerable<Product> OdczytajWedlugKategorii(int id)
      {
         var produkty = bd.Products.Where(
         p => p.CategoryID == id).ToArray();
         return produkty;
      }
   }
}