# to-regex [![NPM version](https://img.shields.io/npm/v/to-regex.svg?style=flat)](https://www.npmjs.com/package/to-regex) [![NPM downloads](https://img.shields.io/npm/dm/to-regex.svg?style=flat)](https://npmjs.org/package/to-regex) [![Build Status](https://img.shields.io/travis/jonschlinkert/to-regex.svg?style=flat)](https://travis-ci.org/jonschlinkert/to-regex)

> Generate a regex from a string or array of strings.

## Table of Contents

- [Install](#install)
- [Usage](#usage)
- [Options](#options)
  * [options.contains](#optionscontains)
  * [options.negate](#optionsnegate)
  * [options.nocase](#optionsnocase)
  * [options.flags](#optionsflags)
  * [options.cache](#optionscache)
- [About](#about)
  * [Related projects](#related-projects)
  * [Contributing](#contributing)
  * [Building docs](#building-docs)
  * [Running tests](#running-tests)
  * [Author](#author)
  * [License](#license)

_(TOC generated by [verb](https://github.com/verbose/verb) using [markdown-toc](https://github.com/jonschlinkert/markdown-toc))_

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save to-regex
```

## Usage

```js
var toRegex = require('to-regex');

console.log(toRegex('foo'));
//=> /^(?:foo)$/

console.log(toRegex('foo', {negate: true}));
//=> /^(?:(?:(?!^(?:foo)$).)*)$/

console.log(toRegex('foo', {contains: true}));
//=> /(?:foo)/

console.log(toRegex(['foo', 'bar'], {negate: true}));
//=> /^(?:(?:(?!^(?:(?:foo)|(?:bar))$).)*)$/

console.log(toRegex(['foo', 'bar'], {negate: true, contains: true}));
//=> /^(?:(?:(?!(?:(?:foo)|(?:bar))).)*)$/
```

## Options

### options.contains

**Type**: `Boolean`

**Default**: `undefined`

Generate a regex that will match any string that _contains_ the given pattern. By default, regex is strict will only return true for exact matches.

```js
var toRegex = require('to-regex');
console.log(toRegex('foo', {contains: true}));
//=> /(?:foo)/
```

### options.negate

**Type**: `Boolean`

**Default**: `undefined`

Create a regex that will match everything except the given pattern.

```js
var toRegex = require('to-regex');
console.log(toRegex('foo', {negate: true}));
//=> /^(?:(?:(?!^(?:foo)$).)*)$/
```

### options.nocase

**Type**: `Boolean`

**Default**: `undefined`

Adds the `i` flag, to enable case-insensitive matching.

```js
var toRegex = require('to-regex');
console.log(toRegex('foo', {nocase: true}));
//=> /^(?:foo)$/i
```

Alternatively you can pass the flags you want directly on [options.flags](#options.flags).

### options.flags

**Type**: `String`

**Default**: `undefined`

Define the flags you want to use on the generated regex.

```js
var toRegex = require('to-regex');
console.log(toRegex('foo', {flags: 'gm'}));
//=> /^(?:foo)$/gm
console.log(toRegex('foo', {flags: 'gmi', nocase: true})); //<= handles redundancy
//=> /^(?:foo)$/gmi
```

### options.cache

**Type**: `Boolean`

**Default**: `true`

Generated regex is cached based on the provided string and options. As a result, runtime compilation only happens once per pattern (as long as options are also the same), which can result in dramatic speed improvements.

This also helps with debugging, since adding options and pattern are added to the generated regex.

**Disable caching**

```js
toRegex('foo', {cache: false});
```

## About

### Related projects

* [has-glob](https://www.npmjs.com/package/has-glob): Returns `true` if an array has a glob pattern. | [homepage](https://github.com/jonschlinkert/has-glob "Returns `true` if an array has a glob pattern.")
* [is-glob](https://www.npmjs.com/package/is-glob): Returns `true` if the given string looks like a glob pattern or an extglob pattern… [more](https://github.com/jonschlinkert/is-glob) | [homepage](https://github.com/jonschlinkert/is-glob "Returns `true` if the given string looks like a glob pattern or an extglob pattern. This makes it easy to create code that only uses external modules like node-glob when necessary, resulting in much faster code execution and initialization time, and a bet")
* [path-regex](https://www.npmjs.com/package/path-regex): Regular expression for matching the parts of a file path. | [homepage](https://github.com/regexps/path-regex "Regular expression for matching the parts of a file path.")
* [to-regex-range](https://www.npmjs.com/package/to-regex-range): Returns a regex-compatible range from two numbers, min and max, with 855,412 generated unit tests… [more](https://github.com/jonschlinkert/to-regex-range) | [homepage](https://github.com/jonschlinkert/to-regex-range "Returns a regex-compatible range from two numbers, min and max, with 855,412 generated unit tests to validate it's accuracy! Useful for creating regular expressions to validate numbers, ranges, years, etc. Returns a string, allowing the returned value to ")

### Contributing

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

### Building docs

_(This document was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme) (a [verb](https://github.com/verbose/verb) generator), please don't edit the readme directly. Any changes to the readme must be made in [.verb.md](.verb.md).)_

To generate the readme and API documentation with [verb](https://github.com/verbose/verb):

```sh
$ npm install -g verb verb-generate-readme && verb
```

### Running tests

Install dev dependencies:

```sh
$ npm install -d && npm test
```

### Author

**Jon Schlinkert**

* [github/jonschlinkert](https://github.com/jonschlinkert)
* [twitter/jonschlinkert](http://twitter.com/jonschlinkert)

### License

Copyright © 2016, [Jon Schlinkert](https://github.com/jonschlinkert).
Released under the [MIT license](https://github.com/jonschlinkert/to-regex/blob/master/LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.1.31, on October 06, 2016._