static void Monitor (string category, string counter, string instance,
                     EventWaitHandle stopper)
{
  if (!PerformanceCounterCategory.Exists (category))
    throw new InvalidOperationException ("Kategoria nie istnieje");

  if (!PerformanceCounterCategory.CounterExists (counter, category))
    throw new InvalidOperationException ("Licznik nie istnieje");

  if (instance == null) instance = "";   // "" oznacza brak egzemplarza, a nie wartość null!
  if (instance != "" &&
      !PerformanceCounterCategory.InstanceExists (instance, category))
    throw new InvalidOperationException ("Egzemplarz nie istnieje");

  float lastValue = 0f;
  using (PerformanceCounter pc = new PerformanceCounter (category,
                                                      counter, instance))
    while (!stopper.WaitOne (200, false))
    {
      float value = pc.NextValue();
      if (value != lastValue)         // Zapis wartości tylko wtedy,
      {                               // gdy uległa zmianie.
        Console.WriteLine (value);
        lastValue = value;
      }
    }
}