void Main()
{
	FolderBasedALC alc = new FolderBasedALC (@"C:\YourAssemblyFolder");
	alc.LoadFromAssemblyName (new AssemblyName ("YourAssembly"));

	foreach (Assembly a in alc.Assemblies)
		Console.WriteLine (a.FullName);
}

class FolderBasedALC : AssemblyLoadContext
{
	readonly string _folder;
	public FolderBasedALC (string folder) => _folder = folder;

	protected override Assembly Load (AssemblyName assemblyName)
	{
		// Próba znalezienia zestawu:
		string targetPath = Path.Combine (_folder, assemblyName.Name + ".dll");

		if (File.Exists (targetPath))
			return LoadFromAssemblyPath (targetPath);   // Załadowanie zestawu

		return null;    // Nie możemy znaleźć — to może być zestaw frameworku
	}
}