using Microsoft.EntityFrameworkCore;  // DbContext, DbSet<T>
using Microsoft.Data.SqlClient; // SqlConnectionStringBuilder.

namespace LinqZEFCore.ModeleEncji;

// klasa zarządzająca połączeniem z bazą danych
public class Northwind : DbContext
{
   // te właściwości opisują tabele w bazie danych
   public DbSet<Category>? Categories { get; set; } = null!;
    public DbSet<Product>? Products { get; set; } = null!;

    protected override void OnConfiguring(
      DbContextOptionsBuilder optionsBuilder)
    {           
      #region Dla SQLite

      string bazaDanych = "Northwind.db";
      string katalog = Environment.CurrentDirectory;
      string sciezka = string.Empty;

      // Baza danych pozostanie w folderze projektu.
      // Automatycznie dopasujemy ścieżkę względną na potrzeby
      // uruchomienia w VS2022 lub w terminalu.

      if (katalog.EndsWith("net8.0"))
      {
         // Uruchamiamy w katalogu <projekt>\bin\<Debug|Release>\net8.0.
         sciezka = Path.Combine("..", "..", "..", bazaDanych);
      }
      else
      {
         // Uruchamiamy w katalogu <projekt>.
         sciezka = bazaDanych;
      }

      sciezka = Path.GetFullPath(sciezka); // Konwersja na ścieżkę bezwzględną.
      WriteLine($"Ścieżka do bazy danych SQLite: {sciezka}");

      if (!File.Exists(sciezka))
      {
         throw new FileNotFoundException(
           message: $"Nie znaleziono {sciezka}.", fileName: sciezka);
      }

      // Używamy SQLite.
      optionsBuilder.UseSqlite($"Data Source={sciezka}");

      #endregion

      #region Dla SQL Server

      SqlConnectionStringBuilder builder = new();

      builder.DataSource = ".";
      builder.InitialCatalog = "Northwind";
      builder.IntegratedSecurity = true;
      builder.Encrypt = true;
      builder.TrustServerCertificate = true;
      builder.MultipleActiveResultSets = true;

      string polaczenie = builder.ConnectionString;
      // WriteLine($"Połączenie z serwerem SQL Server: {polaczenie}");

      // Używamy SQL Server.
      // optionsBuilder.UseSqlServer(polaczenie);

      #endregion
   }

   protected override void OnModelCreating(
      ModelBuilder modelBuilder)
   {
      if (Database.ProviderName is not null &&
          Database.ProviderName.Contains("Sqlite"))
      {
         modelBuilder.Entity<Product>()
          .Property(produkt => produkt.UnitPrice)
          .HasConversion<double>();
      }
   }
}
