﻿using Spectre.Console; // Używamy typu Table.

#region Obsługa wieloplatformowych środowisk i systemów plików

TytulSekcji("Obsługa wieloplatformowych środowisk i systemów plików");

// Utórz tabelę Spectre Console.
Table tabela = new();

// Dodaj dwie odpowiednio pokolorowane kolumny .
tabela.AddColumn("[blue]ELEMENT[/]");
tabela.AddColumn("[blue]WARTOŚĆ[/]");

// Dodaj wiersze.
tabela.AddRow("Path.PathSeparator", PathSeparator.ToString());
tabela.AddRow("Path.DirectorySeparatorChar", DirectorySeparatorChar.ToString());
tabela.AddRow("Directory.GetCurrentDirectory()", GetCurrentDirectory());
tabela.AddRow("Environment.CurrentDirectory", CurrentDirectory);
tabela.AddRow("Environment.SystemDirectory", SystemDirectory);
tabela.AddRow("Path.GetTempPath()", GetTempPath());
tabela.AddRow("");
tabela.AddRow("GetFolderPath(SpecialFolder", "");
tabela.AddRow(" .System)", GetFolderPath(SpecialFolder.System));
tabela.AddRow(" .ApplicationData)", GetFolderPath(SpecialFolder.ApplicationData));
tabela.AddRow(" .MyDocuments)", GetFolderPath(SpecialFolder.MyDocuments));
tabela.AddRow(" .Personal)", GetFolderPath(SpecialFolder.Personal));

// Wypisz tabelę w konsoli
AnsiConsole.Write(tabela);

#endregion

#region Obsługa napędów

TytulSekcji("Obsługa napędów");

Table napedy = new();

napedy.AddColumn("[blue]NAZWA[/]");
napedy.AddColumn("[blue]TYP[/]");
napedy.AddColumn("[blue]FORMAT[/]");
napedy.AddColumn(new TableColumn("[blue]WIELKOŚĆ (BAJTY)[/]").RightAligned());
napedy.AddColumn(new TableColumn("[blue]WOLNE MIEJSCE[/]").RightAligned());

foreach (DriveInfo naped in DriveInfo.GetDrives())
{
   if (naped.IsReady)
   {
      napedy.AddRow(naped.Name, naped.DriveType.ToString(),
      naped.DriveFormat, naped.TotalSize.ToString("N0"),
      naped.AvailableFreeSpace.ToString("N0"));
   }
   else
   {
      napedy.AddRow(naped.Name, naped.DriveType.ToString(),
      string.Empty, string.Empty, string.Empty);
   }
}
AnsiConsole.Write(napedy);

#endregion

#region Praca z katalogami

TytulSekcji("Praca z katalogami");

// definiowanie ścieżki do nowego folderu
// umieszczonego w folderze użytkownika
string katalog = Combine(
   GetFolderPath(SpecialFolder.Personal), "NowyFolder");
WriteLine($"Pracuję w: {katalog}");

// sprawdzenie, czy katalog istnieje
// Musimy jawnie podać, którą metodę Exists wywołujemy,
// ponieważ statycznie zaimportowaliśmy klasy Path i Directory
WriteLine($"Czy istnieje? {Path.Exists(katalog)}");

// utworzenie katalogu
WriteLine("Tworzę katalog...");
CreateDirectory(katalog);

// Tym razem użyjemy metody Directory.Exists.
WriteLine($"Czy istnieje? {Directory.Exists(katalog)}");
Write("Sprawdź, czy katalog istnieje, i naciśnij klawisz ENTER: ");
ReadLine();

// usuwanie katalogu
WriteLine("Usuwam katalog...");
Delete(katalog, recursive: true);
WriteLine($"Czy istnieje? {Path.Exists(katalog)}");

#endregion

#region Praca z plikami

TytulSekcji("Praca z plikami");

// definiowanie ścieżki do plików
// zaczynającej się od folderu użytkownika
katalog = Combine(
   GetFolderPath(SpecialFolder.Personal), "wyjscie");

CreateDirectory(katalog);

// definiowanie ścieżki do pliku
string plikTekstowy = Combine(katalog, "tekst.txt");
string plikKopiaZapasowa = Combine(katalog, "kopiaZapasowa.bak");
WriteLine($"Pracuję z: {plikTekstowy}");

// sprawdzenie, czy plik istnieje
WriteLine($"Czy plik istnieje? {File.Exists(plikTekstowy)}");

// utworzenie nowego pliku tekstowego
// i wpisanie do niego wiersza tekstu
StreamWriter pisanieTekstu = File.CreateText(plikTekstowy);
pisanieTekstu.WriteLine("Witaj, C#!");
pisanieTekstu.Close(); // zamknięcie pliku i zwolnienie zasobów
WriteLine($"Czy plik istnieje? {File.Exists(plikTekstowy)}");

// skopiowanie pliku, z nadpisaniem, jeżeli plik już istnieje
File.Copy(sourceFileName: plikTekstowy,
   destFileName: plikKopiaZapasowa,
   overwrite: true);
WriteLine($"Czy {plikKopiaZapasowa} istnieje? {File.Exists(plikKopiaZapasowa)}");

Write("Sprawdź, czy plik istnieje, i naciśnij klawisz ENTER: ");
ReadLine();

// usunięcie pliku
File.Delete(plikTekstowy);
WriteLine($"Czy plik istnieje? {File.Exists(plikTekstowy)}");

// odczytanie tekstu z pliku kopii zapasowej
WriteLine($"Czytam zawartość pliku {plikKopiaZapasowa}:");
StreamReader czytaniePliku = File.OpenText(plikKopiaZapasowa);
WriteLine(czytaniePliku.ReadToEnd());
czytaniePliku.Close();

#endregion

#region Praca ze ścieżkami

TytulSekcji("Praca ze ścieżkami");

WriteLine($"Nazwa folderu: {GetDirectoryName(plikTekstowy)}");
WriteLine($"Nazwa pliku: {GetFileName(plikTekstowy)}");
WriteLine($"Nazwa pliku bez rozszerzenia: {GetFileNameWithoutExtension(plikTekstowy)}");
WriteLine($"Rozszerzenie pliku: {GetExtension(plikTekstowy)}");
WriteLine($"Losowa nazwa pliku: {GetRandomFileName()}");
WriteLine($"Nazwa pliku tymczasowego: {GetTempFileName()}");

#endregion

#region Pobieranie informacji o pliku

TytulSekcji("Pobieranie informacji o pliku");

FileInfo info = new(plikKopiaZapasowa);
WriteLine($"{plikKopiaZapasowa}:");
WriteLine($"Ma wielkość {info.Length} bajtów.");
WriteLine($"Ostatnio otwierany był {info.LastAccessTime}");
WriteLine($"Atrybut tylko do odczytu ma wartość {info.IsReadOnly}.");

#endregion

#region Sposoby pracy z plikami

WriteLine("Czy plik kopii zapasowej jest skompresowany? {0}",
  info.Attributes.HasFlag(FileAttributes.Compressed));

#endregion
