﻿namespace Biblioteka;

public class OsobaComparer : IComparer<Osoba?>
{
   public int Compare(Osoba x, Osoba y)
   {
      int pozycja;
      if ((x is not null) && (y is not null))
      {
         if ((x.Nazwisko is not null) && (y.Nazwisko is not null))
         {
            // Jeżeli oba nazwiska nie mają wartości null…
            // …porównaj długości nazwisk…
            int wynik = x.Nazwisko.Length.CompareTo(y.Nazwisko.Length);

            // …a jeżeli są równe…
            if (wynik == 0)
            {
               // …to posortuj alfabetycznie…
               return x.Nazwisko.CompareTo(y.Nazwisko);
            }
            else
            {
               // …poza tym sortuj według długości
               pozycja = wynik;
            }
         }
         else if ((x.Nazwisko is not null) && (y.Nazwisko is null))
         {
            pozycja = -1; // Osoba x znajduje się przed osobą y
         }
         else if ((x.Nazwisko is null) && (y.Nazwisko is not null))
         {
            pozycja = 1; // Osoba x znajduje się za osobą y
         }
         else
         {
            pozycja = 0; // Osoby x i y znajdują się na tej samej pozycji
         }        
      }
      else if ((x is not null) && (y is null))
      {
         pozycja = -1; // Osoba x znajduje się przed osobą y
      }
      else if ((x is null) && (y is not null))
      {
         pozycja = 1; // Osoba x znajduje się za osobą y
      }
      else
      {
         pozycja = 0; // Osoby x i y znajdują się na tej samej pozycji
      }
      return pozycja;
   }
}
