﻿#region Instrukcja If

string haslo = "ninja";

if (haslo.Length < 8)
{
  WriteLine("Twoje hasło jest za krótkie. Musi mieć przynajmniej 8 znaków.");
}
else
{
  WriteLine("Masz silne hasło.");
}

#endregion

#region Dopasowanie wzorców z instrukcją if

// Dodanie lub usunięcie cudzysłowu zmieni zachowanie tego kodu.
object o = "3";
int j = 4;

if (o is int i)
{
  WriteLine($"{i} x {j} = {i * j}");
}
else
{
  WriteLine("o nie ma typu int, a zatem nie mogę wykonać mnożenia!");
}

#endregion

#region Instrukcja switch

int liczba = (new Random()).Next(1, 7);
WriteLine($"Wylosowano liczbę {liczba}");

switch (liczba)
{
  case 1:
        WriteLine("Jeden");
        break; // Skacze na koniec instrukcji switch.
     case 2:
        WriteLine("Dwa");
        goto case 1;
     case 3: // Sekcja obsługująca wiele przypadków.
     case 4:
        WriteLine("Trzy lub cztery");
        goto case 1;
     case 5:
		// wstrzymanie na pół sekundy
		System.Threading.Thread.Sleep(500);
        goto Etykieta;
     default:
        WriteLine("Domyślnie");
        break;
  } // Koniec instrukcji switch.

WriteLine("Koniec instrukcji switch.");
Etykieta:
WriteLine("Już za etykietą.");

#endregion

#region Dopasowywanie wzorców z instrukcją switch

Zwierze?[] zwierzeta = new Zwierze?[]
{
  new Kot { Imie = "Karen", DataUrodzenia = new(year: 2022, month: 8, day: 23),
    Nogi = 4, JestUdomowione = true },
  null,
  new Kot { Imie = "Mufasa", DataUrodzenia = new(year: 1994, month: 6, day: 12) },
  new Pajak { Imie = "Paskuda", DataUrodzenia = DateTime.Today,
    JestJadowite = true},
  new Pajak { Imie = "Włochatek", DataUrodzenia= DateTime.Today }
};

string komunikat;

foreach (Zwierze? zwierze in zwierzeta)
{

   switch (zwierze)
   {
      case Kot kotCzworonozny when kotCzworonozny.Nogi == 4:
         komunikat = $"Kot o imieniu {kotCzworonozny.Imie} ma cztery łapy.";
         break;
      case Kot dzikiKot when dzikiKot.JestUdomowione == false:
         komunikat = $"Ten dziki kot ma na imię {dzikiKot.Imie}.";
         break;
      case Kot kot:
         komunikat = $"Kot ma na imię{kot.Imie}.";
         break;
      default: // Domyślny wariant jest używany na końcu
         komunikat = $"Zwierzę o imieniu {zwierze.Imie} to {zwierze.GetType().Name}.";
         break;
      case Pajak pajak when pajak.JestJadowite:
         komunikat = $"Pająk {pajak.Imie} jest jadowity. Uciekaj!";
         break;
      case null:
         komunikat = "To zwierze ma wartość null.";
         break;
   }
   WriteLine($"Instrukcja switch: {komunikat}");

   komunikat = zwierze switch
   {
      Kot kotCzworonozny when kotCzworonozny.Nogi == 4
        => $"Kot o imieniu {kotCzworonozny.Imie} ma cztery łapy.",
      Kot dzikiKot when dzikiKot.JestUdomowione == false
        => $"Ten dziki kot ma na imię {dzikiKot.Imie}.",
      Kot kot
        => $"Kot ma na imię{kot.Imie}.",
      Pajak pajak when pajak.JestJadowite
        => $"Pająk {pajak.Imie} jest jadowity. Uciekaj!",
      null
        => "To zwierze ma wartość null.",
      _
        => $"Zwierzę o imieniu {zwierze.Imie} to {zwierze.GetType().Name}."
   };
   WriteLine($"Wyrażenie switch: {komunikat}");
}

#endregion