﻿using Microsoft.EntityFrameworkCore.ChangeTracking; // CollectionEntry
using Microsoft.EntityFrameworkCore; // dołącza metodę rozszerzającą
using Biblioteka.ModeleEncji; // Northwind, Category, Product
partial class Program
{
   static void ZapytanieOKategorie()
   {
      using (Northwind db = new())
      {
         TytulSekcji("Lista kategorii i liczba przypisanych im produktów:");

         // zapytanie pobiera wszystkie kategorie i związane z nimi produkty
         IQueryable<Category>? kategorie; // = db.Categories?
                                          //.Include(c => c.Products);
         
         db.ChangeTracker.LazyLoadingEnabled = false;

         Write("Włączyć ładowanie chętne? (T/N): ");
         bool ladowanieChetne = (ReadKey(intercept: true).Key == ConsoleKey.T);
         bool ladowanieJawne = false;
         WriteLine();

         if (ladowanieChetne)
         {
            kategorie = db.Categories?.Include(c => c.Products);
         }
         else
         {
            kategorie = db.Categories;

            Write("Włączyć ładowanie jawne? (T/N): ");
            ladowanieJawne = (ReadKey(intercept: true).Key == ConsoleKey.T);
            WriteLine();
         }
         if ((kategorie is null) || (!kategorie.Any()))
         {
            Blad("Nie znaleziono żadnych kategorii.");
            return;
         }
         // wykonaj zapytanie i przejrzyj wyniki
         foreach (Category k in kategorie)
         {
            if (ladowanieJawne)
            {
               Write($"Jawnie załadować produkty z kategorii {k.CategoryName}? (T/N):");
               ConsoleKeyInfo key = ReadKey();
               WriteLine();

               if (key.Key == ConsoleKey.T)
               {
                  CollectionEntry<Category, Product> produkty =
                     db.Entry(k).Collection(k2 => k2.Products);

                  if (!produkty.IsLoaded) produkty.Load();
               }
            }

            WriteLine($"Kategoria {k.CategoryName} ma {k.Products.Count} produktów.");
         }
      }
   }

   static void FiltrowanieDolaczen()
   {
      using (Northwind db = new())
      {
         TytulSekcji("Produkty z minimalną liczbą sztuk w magazynie");

         string? wejscie;
         int sztukWMagazynie;

         do
         {
            Write("Podaj minimalną liczbę sztuk w magazynie: ");
            wejscie = ReadLine();
         } while (!int.TryParse(wejscie, out sztukWMagazynie));

         IQueryable<Category>? kategorie = db.Categories?
           .Include(c => c.Products.Where(p => p.WMagazynie >= sztukWMagazynie));

         if (kategorie is null)
         {
            Blad("Nie znaleziono kategorii.");
            return;
         }

         Info($"ToQueryString: {kategorie.ToQueryString()}");
         foreach (Category k in kategorie)
         {
            WriteLine($"Kategoria {k.CategoryName} ma {k.Products.Count} produktów z przynajmniej {sztukWMagazynie} sztukami w magazynie.");
     
      foreach (Product p in k.Products)
            {
               WriteLine($" Produkt {p.ProductName}: {p.WMagazynie} sztuk");
            }
         }
      }
   }


   static void ZapytanieOProdukty()
   {
      using (Northwind db = new())
      {
         TytulSekcji("Produkty kosztujące więcej niż podana cena; posortowane malejąco: ");
   

         string? wejscie;
         decimal cena;

         do
         {
            Write("Podaj cenę produktu: ");
            wejscie = ReadLine();
         } while (!decimal.TryParse(wejscie, out cena));

         IQueryable<Product>? produkty = db.Products?
           .Where(produkt => produkt.Koszt > cena)
           .OrderByDescending(produkt => produkt.Koszt);

         if ((produkty is null) || (!produkty.Any()))
         {
            Blad("Nie znaleziono produktów.");
            return;
         }

         foreach (Product produkt in produkty)
         {
            WriteLine($"{0}: {1} kosztuje {2:$#,##0.00}. W magazynie jest {3} sztuk.", 
               produkt.ProductID, produkt.ProductName, produkt.Koszt, produkt.WMagazynie);
         }
      }
   }

   private static void PobierzJedenProdukt()
   {
      using Northwind db = new();
      TytulSekcji("Pobieranie jednego produktu");
      string? wejscie;

      int id;
      do
      {
         Write("Podaj identyfikator produktu: ");
         wejscie = ReadLine();
      } while (!int.TryParse(wejscie, out id));
      
      Product? produkt = db.Products?.First(p => p.ProductID == id);

      Info($"First: {produkt?.ProductName}");

      if (produkt is null) Blad("Nie znaleziono produktu metodą First.");

      produkt = db.Products?.Single(p => p.ProductID == id);

      Info($"Single: {produkt?.ProductName}");

      if (produkt is null) Blad("No product found using Single.");
   }



   static void ZapytanieZLike()
   {
      using Northwind db = new();

      TytulSekcji("Dopasowanie wzorców z Like");

      Write("Wprowadź część nazwy produktu: ");
      string? wejscie = ReadLine();

      if (string.IsNullOrWhiteSpace(wejscie))
      {
         Blad("Nie podano części nazwy produktu.");
         return;
      }

      IQueryable<Product>? produkty = db.Products?
         .Where(p => EF.Functions.Like(p.ProductName, $"%{wejscie}%"));

      if ((produkty is null) || (!produkty.Any()))
      {
         Blad("Nie znaleziono produktów.");
         return;
      }

      foreach (Product produkt in produkty)
      {
         WriteLine($"{0}: w magazynie jest {1} sztuk. Produkt nie jest już wytwarzany ? {3}",
            produkt.ProductName, produkt.WMagazynie, produkt.Discontinued);
      }
   }



   static void PobierzLosowyProdukt()
   {
      using Northwind db = new();

      TytulSekcji("Pobieranie losowego produktu");

      int? liczbaWierszy = db.Products?.Count();
      if (liczbaWierszy is null)
      {
         Blad("Tabela produktów jest pusta.");
         return;
      }

      Product? p = db.Products?.FirstOrDefault(
        p => p.ProductID == (int)(EF.Functions.Random() * liczbaWierszy));

      if (p == null)
      {
         Blad("Nie znaleziono produktu.");
         return;
      }

      WriteLine($"Losowy produkt: {p.ProductID} {p.ProductName}");
   }

   private static void LeniweLadowanieBezSledzenia()
   {
      using Northwind db = new();

      TytulSekcji("Leniwe ładowanie bez śledzenia");

      IQueryable<Product>? produkty = db.Products?.AsNoTracking();

      if (produkty is null || !produkty.Any())
      {
         Blad("Nie znaleziono produktów.");
         return;
      }

      foreach (Product p in produkty)
      {
         WriteLine("Produkt {0} jest w kategorii {1}.",
           p.ProductName, p.Category.CategoryName);
      }
   }

}
