using Microsoft.AspNetCore.Server.Kestrel.Core; // HttpProtocols.
using Northwind.ModeleEncji; // Metoda DoajKontekstNorthwind .

#region Configure the web server host and services

var konfigurator = WebApplication.CreateBuilder(args);

konfigurator.Services.AddRazorPages();
konfigurator.Services.DodajKontekstNorthwind();
konfigurator.Services.AddRequestDecompression();

konfigurator.WebHost.ConfigureKestrel((kontekst, opcje) =>
{
  opcje.ConfigureEndpointDefaults(opcjeNasluchiwania =>
  {
    opcjeNasluchiwania.Protocols = HttpProtocols.Http1AndHttp2AndHttp3;
    opcjeNasluchiwania.UseHttps(); // HTTP/3 wymaga zabezpieczenia połączenia.
  });
});

var app = konfigurator.Build();

#endregion

#region Konfiguracja potoku i tras HTTP

if (!app.Environment.IsDevelopment())
{
  app.UseHsts();
}

app.UseRequestDecompression();

app.Use(async (HttpContext kontekst, Func<Task> nastepne) =>
{
  RouteEndpoint? rep = kontekst.GetEndpoint() as RouteEndpoint;

  if (rep is not null)
  {
    WriteLine($"Nazwa punktu koncowego: {rep.DisplayName}");
    WriteLine($"Wzorzec trasy: {rep.RoutePattern.RawText}");
  }

  if (kontekst.Request.Path == "/bonjour")
  {
    await kontekst.Response.WriteAsync("Bonjour Monde!");
    return;
  }

  // Możemy zmodyfikować żądanie przed wywołaniem następnego delegata.
  await nastepne();

  // Możemy zmodyfikować odpowiedź przed wywołaniem następnego delegata.
});

app.UseHttpsRedirection();

app.UseDefaultFiles(); // index.html, default.html itd.
app.UseStaticFiles();

app.MapRazorPages();
app.MapGet("/witaj", () =>
  $"Środowisko to {app.Environment.EnvironmentName}");

#endregion

// Uruchomienie serwera, przygotowanie witryny i oczekiwanie na żądania.
app.Run(); // To jest wywołanie blokujące.
WriteLine("Ta instrukcja jest wykonywana po zatrzymaniu serwera!");
