﻿using Microsoft.EntityFrameworkCore; // ToListAsync<T>.

namespace Northwind.Blazor.Services;

public class SerwerowySerwisNorthwind : ISerwisNorthwind
{
  private readonly KontekstNorthwind _db;

  public SerwerowySerwisNorthwind(KontekstNorthwind db)
  {
    _db = db;
  }
  
  public Task<List<Customer>> PobierzKlientowAsync()
  {
    return _db.Customers.ToListAsync();
  }
  
  public Task<List<Customer>> PobierzKlientowAsync(string kraj)
  {
    return _db.Customers.Where(c => c.Country == kraj).ToListAsync();
  }
  
  public Task<Customer?> PobierzKlientaAsync(string id)
  {
    return _db.Customers.FirstOrDefaultAsync
    (c => c.CustomerId == id);
  }
  
  public Task<Customer> UtworzKlientaAsync(Customer k)
  {
    _db.Customers.Add(k);
    _db.SaveChangesAsync();
    return Task.FromResult(k);
  }
  public Task<Customer> AktualizujKlientaAsync(Customer k)
  {
    _db.Entry(k).State = EntityState.Modified;
    _db.SaveChangesAsync();
    return Task.FromResult(k);
  }

  public Task UsunKlientaAsync(string id)
  {
    Customer? klient = _db.Customers.FirstOrDefaultAsync
    (c => c.CustomerId == id).Result;
    if (klient == null)
    {
      return Task.CompletedTask;
    }
    else
    {
      _db.Customers.Remove(klient);
      return _db.SaveChangesAsync();
    }
  }
}
