﻿using System.Globalization;

OutputEncoding = System.Text.Encoding.UTF8;

#region Pobieranie długości tekstu

string miasto = "Londyn";
WriteLine($"{miasto} ma {miasto.Length} znaków.");

#endregion

#region Pobieranie znaków z ciągu

WriteLine($"Pierwszy znak to {miasto[0]}, a trzeci to {miasto[2]}.");

#endregion

#region Dzielenie ciągu znaków na części

string miasta = "Paryż,Teheran,Warszawa,Sydney,Nowy Jork,Medellin";

string[] tablicaMiast = miasta.Split(',');

WriteLine($"W tablicy zapisano {tablicaMiast.Length} miast.");
foreach (string element in tablicaMiast)
{
   WriteLine(element);
}
#endregion

#region Pobieranie wycinka ciągu znaków

string imieINazwisko = "Adam Nowak";
int indeksSpacji = imieINazwisko.IndexOf(' ');

string imie = imieINazwisko.Substring(
  startIndex: 0, length: indeksSpacji);

string nazwisko = imieINazwisko.Substring(
  startIndex: indeksSpacji + 1);

WriteLine($"Oryginał: {imieINazwisko}");
WriteLine($"Po zamianie: {nazwisko}, {imie}");

#endregion

#region Wyszukiwanie tekstu w ciągu znaków

string firma = "Microsoft";
bool zaczynaSieOdM = firma.StartsWith("M");
bool zawieraN = firma.Contains("N");
WriteLine($"Tekst: {firma}");
WriteLine($"Zaczyna się od litery M: {zaczynaSieOdM}, zawiera literę N: {zawieraN}");

#endregion

#region Porównywanie ciągów znaków

CultureInfo.CurrentCulture = CultureInfo.GetCultureInfo("pl-PL");

string tekst1 = "Marek";
string tekst2 = "MAREK";

WriteLine($"tekst1: {tekst1}, tekst2: {tekst2}");

WriteLine("Metoda Compare: {0}.", string.Compare(tekst1, tekst2));

WriteLine("Metoda Compare(ignoreCase): {0}.",
  string.Compare(tekst1, tekst2, ignoreCase: true));

WriteLine("Metoda Compare(InvariantCultureIgnoreCase): {0}.",
  string.Compare(tekst1, tekst2,
  StringComparison.InvariantCultureIgnoreCase));

// Porównywanie tekstów niemieckich

CultureInfo.CurrentCulture = CultureInfo.GetCultureInfo("de-DE");

tekst1 = "Strasse";
tekst2 = "Straße";

WriteLine($"text1: {tekst1}, text2: {tekst2}");

WriteLine("Metoda Compare: {0}.", string.Compare(tekst1, tekst2,
  CultureInfo.CurrentCulture, CompareOptions.IgnoreNonSpace));

WriteLine("Metoda Compare(IgnoreCase, IgnoreNonSpace): {0}.",
  string.Compare(tekst1, tekst2, CultureInfo.CurrentCulture,
  CompareOptions.IgnoreNonSpace | CompareOptions.IgnoreCase));

WriteLine("Metoda Compare(InvariantCultureIgnoreCase): {0}.",
  string.Compare(tekst1, tekst2,
  StringComparison.InvariantCultureIgnoreCase));

#endregion

#region Złączanie, formatowanie i inne elementy ciągów znaków

string znowZlaczone = string.Join(" => ", tablicaMiast);
WriteLine(znowZlaczone);

string owoce = "jabłka";
decimal cena = 0.39M;
DateTime kiedy = DateTime.Today;

WriteLine($"Interpolowane: W {kiedy:dddd} {owoce} kosztują {cena:C}.");

WriteLine(string.Format("string.Format: W {2:dddd} {0} kosztują {1:C}.",
  arg0: owoce, arg1: cena, arg2: kiedy));

#endregion
