﻿#region Operatory jednoargumentowe

int a = 3;
int b = a++;
WriteLine($"a ma wartość {a}, b ma wartość {b}");

int c = 3;
int d = ++c; // inkrementacja zmiennej c wykonana przed przypisaniem
WriteLine($"c ma wartość {c}, d ma wartość {d}");

#endregion

#region Binarne operacje arytmetyczne

int e = 11;
int f = 3;
WriteLine($"e ma wartość {e}, f ma wartość {f}");
WriteLine($"e + f = {e + f}");
WriteLine($"e - f = {e - f}");
WriteLine($"e * f = {e * f}");
WriteLine($"e / f = {e / f}");
WriteLine($"e % f = {e % f}");

double g = 11.0;
WriteLine($"g ma wartość {g:N1}, f ma wartość {f}");
WriteLine($"g / f = {g / f}");

#endregion

#region Operatory logiczne

bool p = true;
bool q = false;
WriteLine($"AND  | p     | q    ");
WriteLine($"p    | {p & p,-5} | {p & q,-5} ");
WriteLine($"q    | {q & p,-5} | {q & q,-5} ");
WriteLine();
WriteLine($"OR   | p     | q    ");
WriteLine($"p    | {p | p,-5} | {p | q,-5} ");
WriteLine($"q    | {q | p,-5} | {q | q,-5} ");
WriteLine();
WriteLine($"XOR  | p     | q    ");
WriteLine($"p    | {p ^ p,-5} | {p ^ q,-5} ");
WriteLine($"q    | {q ^ p,-5} | {q ^ q,-5} ");

#endregion

#region Warunkowe operatory logiczne

WriteLine();
WriteLine($"p & DoStuff() = {p & ZrobCos()}");
WriteLine($"q & DoStuff() = {q & ZrobCos()}");

WriteLine();
WriteLine($"p && DoStuff() = {p && ZrobCos()}");
WriteLine($"q && DoStuff() = {q && ZrobCos()}");

#endregion

#region Operatory bitowe i przesunięć

WriteLine();

int x = 10;
int y = 6;

WriteLine($"Wyrażenie  | Dziesiętnie |   Binarnie");
WriteLine($"-------------------------------------");
WriteLine($"x          | {x,11} | {x:B8}");
WriteLine($"y          | {y,11} | {y:B8}");
WriteLine($"x & y      | {x & y,11} | {x & y:B8}");
WriteLine($"x | y      | {x | y,11} | {x | y:B8}");
WriteLine($"x ^ y      | {x ^ y,11} | {x ^ y:B8}");

// Przesuń x w lewo o trzy bity.
WriteLine($"x << 3     | {x << 3,11} | {x << 3:B8}");

// Pomnóż x przez 8.
WriteLine($"x * 8      | {x * 8,11} | {x * 8:B8}");

// Przesuń y w prawo o jeden bit.
WriteLine($"y >> 1     | {y >> 1,11} | {y >> 1:B8}");

#endregion

static bool ZrobCos()
{
   WriteLine("Coś właśnie robię.");
   return true;
}
