﻿using System.Xml;

#region Przechowywanie obiektów dowolnego typu

object wysokosc = 1.88; // zapisanie wartości typu double
object imie = "Amir"; // zapisanie wartości typu string
Console.WriteLine($"{imie} mierzy całe {wysokosc}.");

//int dlugosc1 = imie.Length; // powoduje błąd kompilacji!
int dlugosc2 = ((string)imie).Length; // poinformuj kompilator, że pracuje z typem string
Console.WriteLine($"{imie} ma {dlugosc2} znaków.");

#endregion

#region Używanie typu dynamic

dynamic cos;

// przechowywanie wartości typu string w zmiennej typu dynamic
// typ string ma właściwość Length
//cos = "Ahmed";

// typ int nie ma właściwości Length
// cos = 12;

// Tablica dowolnego typu ma właściwość Length
cos = new[] { 3, 5, 7 };

// tę instrukcję można skompilować, ale może ona powodować błędy w czasie pracy programu,
// jeżeli wartość zapisana w zmiennej nie ma właściwości o nazwie Length!
Console.WriteLine($"Wartość w zmiennej cos ma długość {cos.Length}");

//Wypisuje typ wartości zapisanej w zmiennej cos.
Console.WriteLine($"Wartość w zmiennej cos jest typu {cos.GetType()}");

#endregion

#region Określanie typu zmiennej lokalnej

int populacja = 38_000_000; // 38 mln ludzi w Polsce
double waga = 1.88; // w kilogramach
decimal cena = 4.99M; // w złotówkach
string owoce = "jabłka"; // ciąg znaków w cudzysłowie
char litera = 'Z'; // znaki umieszczamy między apostrofami
bool radosc = true; // typ bool przyjmuje wartości true lub false

#endregion

#region Wnioskowanie typu zmiennej lokalnej

// dobre użycie słowa kluczowego var, ponieważ unikamy w nim
// niepotrzebnego powtórzenia typu, tak jak w dłuższej, drugiej instrukcji.
var xml1 = new XmlDocument();
XmlDocument xml2 = new XmlDocument();

// złe użycie słowa kluczowego var, ponieważ nie da się łatwo określić typu zmiennej.
// Lepiej jest jawnie podać typ, tak jak w drugiej instrukcji.
var plik1 = File.CreateText("plik.txt");
//StreamWriter plik2 = File.CreateText("plik.txt");

#endregion

#region Pobieranie i ustalanie domyślnych wartości typów

Console.WriteLine($"default(int) = {default(int)}");
Console.WriteLine($"default(bool) = {default(bool)}");
Console.WriteLine($"default(DateTime) = {default(DateTime)}");
Console.WriteLine($"default(string) = {default(string)}");

int liczba = 13;
Console.WriteLine($"Zmienna liczba ma wartość: {liczba}");
liczba = default;
Console.WriteLine($"Zmienna liczba ma domyślną wartość: {liczba}");

#endregion