using Microsoft.EntityFrameworkCore; // DbContext, DbContextOptionsBuilder
namespace BibliotekaWspolna;

// zajmuje się obsługą połączenia z bazą danych
public class Northwind : DbContext
{
   // te właściwości odwzorowują tabele z bazy danych
   public DbSet<Category> Categories { get; set; }
   public DbSet<Product> Products { get; set; }


   protected override void OnConfiguring(
     DbContextOptionsBuilder optionsBuilder)
   {
	  string sciezka = Path.Combine(
        Environment.CurrentDirectory, "Northwind.db");

      string polaczenie = $"Filename={sciezka}";
      ConsoleColor poprzedniKolor = ForegroundColor;
      ForegroundColor = ConsoleColor.DarkYellow;
      WriteLine($"Połączenie: {polaczenie}");
      ForegroundColor = poprzedniKolor;

      optionsBuilder.UseSqlite(polaczenie);

      optionsBuilder.UseLazyLoadingProxies();
   }

  protected override void OnModelCreating(
    ModelBuilder modelBuilder)
  {
      // przykład użycia płynnego API zamiast atrybutów,
      // aby ograniczyć długość nazwy kategorii do 40 znaków
      modelBuilder.Entity<Category>()
         .Property(category => category.CategoryName)
         .IsRequired()  // NOT NULL
         .HasMaxLength(15);

      if (StaleProjektu.DostawcaDanych == "SQLite")
      {
         // dodane w celu "naprawienia" braku typu decimal w SQLite
         modelBuilder.Entity<Product>()
            .Property(product => product.Koszt)
            .HasConversion<double>();
      }

      // globalny foltr usuwający nieprodukowane już produkty
      modelBuilder.Entity<Product>()
      .HasQueryFilter(p => !p.Discontinued);
  }
}
