# Rozdział 11. - Przykłady

Przykłady z rozdziału 11. (Reactive Extensions) książki C# 10.0. Programowanie

## Podstawowe interfejsy

* [Listing 1. Interfejsy IObservable&lt;T&gt; oraz IObserver&lt;T&gt;](Rx/FundamentalInterfaces/Program.cs#L10-L20)
* [Listing 2. Prosta implementacja interfejsu IObservable&lt;T&gt;](Rx/FundamentalInterfaces/MySubscriber.cs#L3-L8)
* [Listing 3. Proste zimne źródło zdarzeń](Rx/FundamentalInterfaces/SimpleColdSource.cs#L3-L18)
* [Listing 4. Dołączanie obserwatora do źródła](Rx/FundamentalInterfaces/Program.cs#L3-L5)
* [Listing 5. Zimne źródło udostępniające zawartość pliku](Rx/FundamentalInterfaces/FilePusher.cs#L3-L33)
* [Listing 6. Obsługa błędów systemu plików, lecz nie błędów obserwatora](Rx/FundamentalInterfaces/FilePusherWithErrorHandling.cs#L11-L62)
* [Listing 7. Źródło IObservable<T> monitorujące naciśnięcia klawiszy](Rx/FundamentalInterfaces/KeyWatcher.cs#L3-L56)
* [Listing 8. Dołączanie obserwatora do źródła](Rx/FundamentalInterfaces/AttachingAnObserver.cs#L7-L10)

## Publikowanie i subskrypcja z wykorzystaniem delegatów

* [Listing 9. Źródło obserwowalne wykorzystujące delegaty](Rx/DelegateBasedPubSub/DelegateBasedSource.cs#L7-L29)
* [Listing 10. Źródło asynchroniczne](Rx/DelegateBasedPubSub/AsyncSource.cs#L7-L28)
* [Listing 11. Źródło ciepłe wykorzystujące delegaty](Rx/DelegateBasedPubSub/DelegateBasedHotSource.cs#L10-L24)
* [Listing 12. Subskrypcja bez implementowania interfejsu IObserver&lt;T&gt;](Rx/DelegateBasedPubSub/Program.cs#L7-L9)

## Generator sekwencji

* [Listing 13. Generowanie elementów](Rx/Generation/Program.cs#L13-L21)
* [Listing 14. Generowanie elementów z opóźnieniami](Rx/Generation/Program.cs#L26-L35)

## Zapytania LINQ

* [Listing 15. Filtrowanie elementów przy użyciu zapytania LINQ](Rx/LinqQueries/MainWindow.xaml.cs#L17-L26)
* [Listing 16. Przechwytywanie myszy](Rx/LinqQueries/MainWindow.xaml.cs#L29-L40)

### Operatory grupowania

* [Listing 17. Grupowanie zdarzeń](Rx/LinqQueries/Grouping.cs#L11-L29)

### Operatory Join

* [Listing 18. Wyrażenie zapytania z klauzulą join](Rx/LinqQueries/QueryExpressionJoin.xaml.cs#L17-L31)
* [Listing 19. Metoda Join ](Rx/LinqQueries/CodeJoin.xaml.cs#L27-L31)
* [Listing 20. Dodawanie nowej linii dla każdej operacji przeciągnięcia wskaźnika myszy](Rx/LinqQueries/GroupJoin.xaml.cs#L29-L43)

## Operatory biblioteki Rx

### Merge

* [Listing 21. Łączenie obserwowalnych źródeł](Rx/RxQueryOperators/MergingObservables.xaml.cs#L17-L37)

### Operatory Buffer i Window

* [Listing 22. Wygładzanie wyników przy użyciu operatora Buffer](Rx/RxQueryOperators/SmoothingWithBuffer.xaml.cs#L40-L43)
* [Listing 23. Wygładzanie z użyciem operatora Window](Rx/RxQueryOperators/SmoothingWithWindow.xaml.cs#L40-L47)
* [Listing 24. Podział tekstu na słowa przy użyciu okien](Rx/RxQueryOperators/WordBreaking.cs#L11-L18)
* [Listing 25. Dzielenie słów z wykorzystaniem operatora Buffer](Rx/RxQueryOperators/WordBreaking.cs#L25-L29)

### Operator Scan

* [Listing 26. Prosty rynek notowań ze strumieniem testowym](Rx/RxQueryOperators/Trade.cs#L6-L26)
* [Listing 27. Sumowanie z wykorzystaniem operatora Aggregate](Rx/RxQueryOperators/Aggregation.cs#L9-L13)
* [Listing 28. Suma częściowa wyliczana przy użyciu operatora Scan](Rx/RxQueryOperators/Aggregation.cs#L18-L22)

## Mechanizmy szeregujące

* [Listing 29. Użycie metody ObserveOn konkretnego mechanizmu szeregującego](Rx/RxSchedulers/MainWindow.xaml.cs#L16-L23)
* [Listing 30. Metoda ObserveOn przeznaczona dla aplikacji WPF i używając obiektu Dispatcher](Rx/RxSchedulers/WpfSpecificObserveOn.xaml.cs#L15)
* [Listing 31. Obserwowanie bieżącego obiektu Dispatcher](Rx/RxSchedulers/UseCurrentDispatcher.xaml.cs#L16)

## Tematy

* [Listing 32. Implementacja interfejsu IObservable&lt;T&gt; przy użyciu obiektu Subject&lt;T&gt;](Rx/RxSubjects/KeyWatcher.cs#L5-L21)
* [Listing 33. Udostępnianie implementacji IObservable&lt;T&gt; jako właściwości](Rx/RxSubjects/ObservableProperty/KeyWatcher.cs#L5-L18)

## Dostosowanie

* [Listing 34. Konwersja IEnumerable&lt;T&gt; na IObservable&lt;T&gt;](Rx/Adaptation/IEnumerableToObservable.cs#L7-L11)
* [Listing 35. Jak mogłoby wyglądać użycie metody ToObservable, gdyby nie musiała ona korzystać z mechanizmu szeregującego](Rx/Adaptation/IEnumerableToObservable.cs#L13-L39)
* [Listing 36. Stosowanie źródła IObservable&lt;T&gt; jako obiektu IEnumerable&lt;T&gt;](Rx/Adaptation/IObservableToEnumerable.cs#L7-L13)
* [Listing 37. Opakowywanie zdarzeń w formie obiektu IObservable&lt;T&gt;](Rx/Adaptation/Events.cs#L10-L17)
* [Listing 38. Opakowywanie zdarzeń z wykorzystaniem delegatów](Rx/Adaptation/Events.cs#L26-L28)
* [Listing 39. Udostępnianie danej Task&lt;T&gt; jako IObservable&lt;T&gt;](Rx/Adaptation/Async.cs#L10-L16)
* [Listing 40. Tworzenie nowego zadania dla każdego subskrybenta](Rx/Adaptation/Async.cs#L21-L29)

## Operacje z uzależnieniami czasowymi

* [Listing 41. Regularne zwracanie elementów przy użyciu metody Interval](Rx/Timed/Intervals.cs#L9-L10)
* [Listing 42. Drugi subskrybent źródła utworzonego przy użyciu metody Interval](Rx/Timed/Intervals.cs#L18-L20)
* [Listing 43. Zliczanie słów wpisywanych w ciągu minuty](Rx/Timed/WordsPerMinute.cs#L17-L24)
* [Listing 44. Użycie metody Timer, która zwraca jeden element](Rx/Timed/Timers.cs#L10-L11)
* [Listing 45. Elementy ze znacznikami czasu](Rx/Timed/Timers.cs#L16-L19)
* [Listing 46. Mierzenie odstępów pomiędzy elementami](Rx/Timed/Timers.cs#L24-L27)
* [Listing 47. Okna czasowe tworzone przy użyciu operatora Buffer](Rx/Timed/WordsPerMinute.cs#L31-L34)
* [Listing 48. Zachodzące na siebie okna pomiarowe](Rx/Timed/WordsPerMinute.cs#L41-L44)
