﻿namespace StandardOperators;

public record Course(
    string Title,
    string Category,
    int Number,
    DateOnly PublicationDate,
    TimeSpan Duration)
{
    public static readonly Course[] Catalog =
    {
            new Course(
                Title: "Elementy geometrii",
                Category: "MAT", Number: 101, Duration: TimeSpan.FromHours(3),
                PublicationDate: new DateOnly(2009, 5, 20)),
            new Course(
                Title: "Kwadratura koła",
                Category: "MAT", Number: 102, Duration: TimeSpan.FromHours(7),
                PublicationDate: new DateOnly(2009, 4, 1)),
            new Course(
                Title: "Transplantacja organów w celach odtworzeniowych",
                Category: "BIO", Number: 305, Duration: TimeSpan.FromHours(4),
                PublicationDate: new DateOnly(2002, 7, 19)),
            new Course(
                Title: "Geometria hiperboliczna",
                Category: "MAT", Number: 207, Duration: TimeSpan.FromHours(5),
                PublicationDate: new DateOnly(2007, 10, 5)),
            new Course(
                Title: "Uproszczone struktury danych do celów demonstracyjnych",
                Category: "CSE", Number: 104, Duration: TimeSpan.FromHours(2),
                PublicationDate: new DateOnly(2021, 11, 8)),
            new Course(
                Title: "Wprowadzenie do anatomii i fizjologii człowieka",
                Category: "BIO", Number: 201, Duration: TimeSpan.FromHours(12),
                PublicationDate: new DateOnly(2001, 4, 11)),
        };
}