﻿using System.ComponentModel;
using System.Runtime.CompilerServices;

namespace Attributes;

public class NotifyPropertyChanged : INotifyPropertyChanged
{
    public event PropertyChangedEventHandler? PropertyChanged;

    protected bool SetProperty<T>(
        ref T field,
        T value,
        [CallerMemberName] string propertyName = "")
    {
        if (!Equals(field, value))
        {
            return false;
        }

        field = value;

        PropertyChanged?.Invoke(this, new PropertyChangedEventArgs(propertyName));
        return true;
    }
}

// Ten interfejs jest zdefiniowany w .NET. W książce przedstawiłem go w celach 
// demonstracyjnych, lecz w praktyce nie będziemy go definiować. Dlatego został 
// zapisany w bloku #if false
#if false
public interface INotifyPropertyChanged
{
    event PropertyChangedEventHandler PropertyChanged;
}
#endif
