# Rozdział 10. - Przykłady

Przykłady z rozdziału 10. (LINQ) książki C#. 10.0. Programowanie

## Wyrażenia zapytań

* [Listing 1. Wyrażenie zapytania LINQ](Linq/QueryExpressions/Program.cs#L13-L21)
* [Listing 2. Analogiczny kod, który nie korzysta z LINQ](Linq/QueryExpressions/Program.cs#L26-L33)
* [Listing 3. Zapytanie pobierające wartość jednej właściwości](Linq/QueryExpressions/Program.cs#L38-L46)
* [Listing 4. Efekt konwersji wyrażenia zapytania](Linq/QueryExpressions/Program.cs#L51-L54)
* [Listing 5. Sposób rozwijania trywialnych klauzul select](Linq/QueryExpressions/Program.cs#L59-L61)
* [Listing 6. Zapytanie z klauzulą let](Linq/QueryExpressions/Program.cs#L66-L70)
* [Listing 7. Sposób (przybliżony) rozwijania wyrażeń zapytań z wieloma zmiennymi zakresu](Linq/QueryExpressions/Program.cs#L75-L79)
* [Listing 8. Całkowicie bezsensowne metody Where oraz Select](Linq/QueryExpressions/SillyLinqProvider.cs#L3-L16)
* [Listing 9. Bezsensowne zapytanie](Linq/QueryExpressions/Program.cs#L84-L86)
* [Listing 10. Sposób, w jaki kompilator przekształcił nasze bezsensowne zapytanie](Linq/QueryExpressions/Program.cs#L91)
* [Listing 11. Niestandardowy dostawca LINQ dla danych typu CultureInfo[]](Linq/CustomLinqExample/Program.cs)

## Przetwarzanie opóźnione

* [Listing 12. Zapytanie, dla którego źródłem danych jest sekwencja nieskończona](Linq/QueryInifiniteSource/Program.cs)
* [Listing 13. Niestandardowy operator Where o opóźnionym działaniu](Linq/QueryInifiniteSource/CustomDeferredLinqProvider.cs#L6-L19)
* [Listing 14. Niezamierzone, wielokrotne przetwarzanie zapytania opóźnionego](Linq/QueryExpressions/Program.cs#L96-L110)

## LINQ, typy ogólne oraz interfejs IQueryable&lt;T&gt;

* [Listing 15. Interfejsy IQueryable oraz IQueryable<T>](Linq/QueryExpressions/Program.cs#L116-L133)
* [Listing 16. Metody Where dla typów IEnumerable<T> oraz IQueryable<T>](Linq/QueryExpressions/Program.cs#L135-L149)

## Standardowe operatory LINQ 

* [Listing 17. Proste źródło danych dla zapytań LINQ](Linq/StandardOperators/Course.cs#L3-L37)

### Filtrowanie

* [Listing 18. Operator Where z indeksem](Linq/StandardOperators/Filtering.cs#L7-L8)
* [Listing 19. Operator OfType<T>](Linq/StandardOperators/Filtering.cs#L11-L17)

### Selekcja

* [Listing 20. Operator Select z indeksem](Linq/StandardOperators/Projection.cs#L7-L8)
* [Listing 21. Wersja operatora Select z indeksem operująca na wynikach operatora Where](Linq/StandardOperators/Projection.cs#L13-L15)
* [Listing 22. Użycie operatora Select z indeksem przed operatorem Where](Linq/StandardOperators/Projection.cs#L20-L23)
* [Listing 23. Pobieranie większej ilości danych niż to konieczne](Linq/StandardOperators/Projection.cs#L30-L36)
* [Listing 24. Klauzula select korzystająca z typu anonimowego](Linq/StandardOperators/Projection.cs#L43-L45)
* [Listing 25. Stosowanie operatora Select do przekształcania liczb](Linq/StandardOperators/Projection.cs#L54-L58)

### Operator SelectMany

* [Listing 26. Stosowanie operatora SelectMany w wyrażeniu zapytania](Linq/StandardOperators/Projection.cs#L63-L72)
* [Listing 27. Operator SelectMany](Linq/StandardOperators/Projection.cs#L80-L82)
* [Listing 28. Spłaszczanie tablicy nieregularnej](Linq/StandardOperators/Projection.cs#L87-L98)
* [Listing 29. Wersja metody SelectMany, która nie korzysta z projekcji elementów](Linq/StandardOperators/Projection.cs#L112)
* [Listing 30. Jedna z implementacji metody SelectMany](Linq/StandardOperators/Projection.cs#L115-L126)

### Podział na części

* [Listing 31. Podział sekwencji na fragmenty przy użyciu operatora Chunk](Linq/StandardOperators/Chunking.cs#L7-L14)

### Określanie porządku

* [Listing 32. Wyrażenie zapytania z klauzulą orderby](Linq/StandardOperators/Ordering.cs#L7-L9)
* [Listing 33. Jak nie używać wielu kryteriów sortowania](Linq/StandardOperators/Ordering.cs#L14-L17)
* [Listing 34. Wyrażenie zapytania wykorzystujące kilka kryteriów sortowania ](Linq/StandardOperators/Ordering.cs#L22-L24)
* [Listing 35. Dwa kryteria sortowania określane w formie wywołań operatorów LINQ](Linq/StandardOperators/Ordering.cs#L29-L31)

### Konkretne elementy i podzakresy

* [Listing 36. Zastosowanie operatora Single ](Linq/StandardOperators/Subranges.cs#L7-L11)
* [Listing 37. Operator Single z predykatem](Linq/StandardOperators/Subranges.cs#L16-L17)
* [Listing 38. Użycie operatora First w celu pobrania najdłuższego kursu](Linq/StandardOperators/Subranges.cs#L22-L25)
* [Listing 39. Użycie operatora SingleOrDefault z jawnie podaną wartością domyślną](Linq/StandardOperators/Subranges.cs#L32)
* [Listing 40. Jak nie należy używać operatora ElementAt](Linq/StandardOperators/Subranges.cs#L39-L45)

### Agregacja

* [Listing 41. Operator Average wykorzystujący projekcję](Linq/StandardOperators/Aggregation.cs#L11-L12)
* [Listing 42. Operator Max korzystający z projekcji](Linq/StandardOperators/Aggregation.cs#L17)
* [Listing 43. Operator Max z projekcją dotyczącą kryterium, a nie wyniku](Linq/StandardOperators/Aggregation.cs#L22)
* [Listing 44. Operator Max z projekcją dotyczącą kryterium, a nie wyniku oraz zgłaszanie wy-jątku w razie wystąpienia błędu lub operowania na kolekcji pustej](Linq/StandardOperators/Aggregation.cs#L27-L28)
* [Listing 45. Użycie operatora Sum oraz Aggregate o analogicznym znaczeniu](Linq/StandardOperators/Aggregation.cs#L33-L35)
* [Listing 46. Implementacja operatora Max przy użyciu operatora Aggregate](Linq/StandardOperators/Aggregation.cs#L40-L42)
* [Listing 47. Implementacja średniej przy użyciu operatora Aggregate](Linq/StandardOperators/Aggregation.cs#L47-L56)
* [Listing 48. Użycie operatora Aggregate do wyliczenia prostokąta opisującego inne prostokąty](Linq/StandardOperators/Aggregation.cs#L59-L60)
* [Listing 49. Nieco bardziej rozbudowany i mniej tajemniczy sposób wyznaczania prostokąta opisującego](Linq/StandardOperators/Aggregation.cs#L64-L68)
* [Listing 50. Efekt działania operatora Aggregate](Linq/StandardOperators/Aggregation.cs#L78)

### Operacje na zbiorach

* [Listing 51. Usuwanie duplikatów przy użyciu operatora Distinct](Linq/StandardOperators/SetOperations.cs#L7)

### Operatory działające na całych sekwencjach z zachowaniem kolejności

* [Listing 52. Łączenie list przy użyciu operatora Zip](Linq/StandardOperators/WholeSequenceOrderPreserving.cs#L7-L14)

### Grupowanie

* [Listing 53. Grupujące wyrażenie zapytania](Linq/StandardOperators/Grouping.cs#L7-L20)
* [Listing 54. Rozwinięcie prostego zapytania grupującego](Linq/StandardOperators/Grouping.cs#L25)
* [Listing 55. Zapytanie grupujące z projekcją elementów](Linq/StandardOperators/Grouping.cs#L30-L31)
* [Listing 56. Rozwinięcie wyrażenia zapytania wykorzystującego projekcję elementów](Linq/StandardOperators/Grouping.cs#L36-L37)
* [Listing 57. Zapytanie grupujące z projekcją grup](Linq/StandardOperators/Grouping.cs#L42-L45)
* [Listing 58. Rozwinięte zapytanie grupujące z projekcją grup](Linq/StandardOperators/Grouping.cs#L50-L53)
* [Listing 59. Operator GroupBy wykorzystujący projekcje kluczy i grup](Linq/StandardOperators/Grouping.cs#L58-L61)
* [Listing 60. Operator GroupBy wykorzystujący projekcję kluczy, elementów oraz grup](Linq/StandardOperators/Grouping.cs#L66-L71)
* [Listing 61. Złożony klucz grupowania](Linq/StandardOperators/Grouping.cs#L76-L86)

### Złączenia

* [Listing 62. Klasa łącząca studenta z kursem](Linq/StandardOperators/CourseChoice.cs#L3)
* [Listing 63. Zapytanie z klauzulą join](Linq/StandardOperators/Joins.cs#L16-L35)
* [Listing 64. Bezpośrednie wykorzystanie operatora Join](Linq/StandardOperators/Joins.cs#L40-L44)
* [Listing 65. Pogrupowane złączenie](Linq/StandardOperators/Joins.cs#L49-L61)
* [Listing 66. Operator GroupJoin](Linq/StandardOperators/Joins.cs#L66-L70)

### Konwersje

* [Listing 67. Jak nie należy rzutować sekwencji](Linq/StandardOperators/Conversion.cs#L7-L8)
* [Listing 68. Jak należy rzutować sekwencje](Linq/StandardOperators/Conversion.cs#L15)
* [Listing 69. Tworzenie kolekcji asocjacyjnej](Linq/StandardOperators/Conversion.cs#L20-L25)
