﻿namespace Exceptions;

class Rethrow
{
    public static void BadRethrow()
    {
        try
        {
            DoSomething();
        }
        catch (IOException x)
        {
            LogIOError(x);
            // Kolejny wiersz kodu jest NIEPRAWIDŁOWY!
            throw x;  // Tak nie należy powtórnie zgłaszać wyjątku
        }
    }

    public static void GoodRethrow()
    {
        try
        {
            DoSomething();
        }
        catch (IOException x)
        {
            LogIOError(x);
            throw;
        }
    }

    private static void DoSomething()
    {
    }

    private static void LogIOError(IOException x)
    {
    }
}
