﻿using System.Net; // IPHostEntry, Dns, IPAddress
using System.Net.NetworkInformation; // Ping, PingReply, IPStatus

using static System.Console;

Write("Podaj poprawny adres w internecie: ");
String? url = ReadLine();

if (string.IsNullOrWhiteSpace(url))
{
   url = "https://stackoverflow.com/search?q=securestring";
}

Uri uri = new(url);

WriteLine($"URL: {url}");
WriteLine($"Protokół: {uri.Scheme}");
WriteLine($"Port: {uri.Port}");
WriteLine($"Host: {uri.Host}");
WriteLine($"Ścieżka: {uri.AbsolutePath}");
WriteLine($"Zapytanie: {uri.Query}");

IPHostEntry daneHosta = Dns.GetHostEntry(uri.Host);
WriteLine($"{daneHosta.HostName} ma przypisany takie adresy IP:");
foreach (IPAddress adres in daneHosta.AddressList)
{
   WriteLine($" {adres}  {adres.AddressFamily}");
}

try
{
   Ping ping = new();
   WriteLine("Wysyłam żądanie ping do serwera. Proszę czekać...");
   PingReply odpowiedz = ping.Send(uri.Host);

   WriteLine($"{uri.Host} na wysłany ping odpowiedział: {odpowiedz.Status}.");
   if (odpowiedz.Status == IPStatus.Success)
   {
      WriteLine($"Hostowi {0} odpowiedź zajęła {1:N0} ms",
        arg0: odpowiedz.Address,
        arg1: odpowiedz.RoundtripTime);
   }
}
catch (Exception ex)
{
   WriteLine($"Wyjątek {ex.GetType().ToString()} z komunikatem {ex.Message}");
}

