using System.ComponentModel.DataAnnotations; // [Required], [StringLength]
using System.ComponentModel.DataAnnotations.Schema; // [Column]

namespace BibliotekaWspolna;

public class Product
{
  public int ProductId { get; set; } // klucz główny

  [Required]
  [StringLength(40)]
  public string ProductName { get; set; } = null!;

  [Column("UnitPrice", TypeName = "money")]
  public decimal? Koszt { get; set; } // nazwa właściwości != nazwa kolumny

  [Column("UnitsInStock")]
  public short? WMagazynie { get; set; }

  public bool Discontinued { get; set; }

  // te dwie właściwości definiują zależność od klucza obcego
  // w tabeli Categories
  public int CategoryId { get; set; }
  public virtual Category Category { get; set; } = null!;
}
