﻿using static System.Console;
using static System.IO.Directory;
using static System.IO.Path;
using static System.Environment;

WypiszInfoOSystemiePlikow();
// PracaZNapedami();
// PracaZKatalogami();
// PracaZPlikami();

static void WypiszInfoOSystemiePlikow()
{
   WriteLine("{0,-33} {1}", arg0: "Path.PathSeparator",
     arg1: PathSeparator);
   WriteLine("{0,-33} {1}", arg0: "Path.DirectorySeparatorChar",
     arg1: DirectorySeparatorChar);
   WriteLine("{0,-33} {1}", arg0: "Directory.GetCurrentDirectory()",
     arg1: GetCurrentDirectory());
   WriteLine("{0,-33} {1}", arg0: "Environment.CurrentDirectory",
     arg1: CurrentDirectory);
   WriteLine("{0,-33} {1}", arg0: "Environment.SystemDirectory",
     arg1: SystemDirectory);
   WriteLine("{0,-33} {1}", arg0: "Path.GetTempPath()",
     arg1: GetTempPath());

   WriteLine("GetFolderPath(SpecialFolder");
   WriteLine("{0,-33} {1}", arg0: " .System)",
     arg1: GetFolderPath(SpecialFolder.System));
   WriteLine("{0,-33} {1}", arg0: " .ApplicationData)",
     arg1: GetFolderPath(SpecialFolder.ApplicationData));
   WriteLine("{0,-33} {1}", arg0: " .Moje Dokumenty)",
     arg1: GetFolderPath(SpecialFolder.MyDocuments));
   WriteLine("{0,-33} {1}", arg0: " .Osobisty)",
     arg1: GetFolderPath(SpecialFolder.Personal));
}


static void PracaZNapedami()
{
   WriteLine("{0,-30} | {1,-10} | {2,-7} | {3,18} | {4,18}",
      "Nazwa", "Typ", "Format", "Wielkość (bajtów)", "Wolne miejsce");

   foreach (DriveInfo naped in DriveInfo.GetDrives())
   {
      if (naped.IsReady)
      {
         WriteLine("{0,-30} | {1,-10} | {2,-7} | {3,18:N0} | {4,18:N0}",
            naped.Name, naped.DriveType, naped.DriveFormat,
            naped.TotalSize, naped.AvailableFreeSpace);
      }
      else
      {
         WriteLine("{0,-30} | {1,-10}", naped.Name, naped.DriveType);
      }
   }
}


static void PracaZKatalogami()
{
   // definiowanie ścieżki do nowego folderu
   // umieszczonego w folderze użytkownika
   string katalog = Combine(
      GetFolderPath(SpecialFolder.Personal),
      "Kod", "Rozdzial09", "NowyFolder");

   WriteLine($"Pracuję w: {katalog}");

   // sprawdzenie, czy katalog istnieje
   WriteLine($"Czy istnieje? {Exists(katalog)}");

   // utworzenie katalogu
   WriteLine("Tworzę katalog...");
   CreateDirectory(katalog);
   WriteLine($"Czy istnieje? {Exists(katalog)}");
   Write("Sprawdź, czy katalog istnieje, i naciśnij klawisz ENTER: ");
   ReadLine();

   // usuwanie katalogu
   WriteLine("Usuwam katalog...");
   Delete(katalog, recursive: true);
   WriteLine($"Czy istnieje? {Exists(katalog)}");
}


static void PracaZPlikami()
{
   // definiowanie ścieżki do plików
   // zaczynającej się od folderu użytkownika
   string katalog = Combine(
      GetFolderPath(SpecialFolder.Personal),
      "Kod", "Rozdzial09", "wyjscie");

   CreateDirectory(katalog);

   // definiowanie ścieżki do pliku
   string plikTekstowy = Combine(katalog, "tekst.txt");
   string plikKopiaZapasowa = Combine(katalog, "kopiaZapasowa.bak");
   WriteLine($"Pracuję z: {plikTekstowy}");

   // sprawdzenie, czy plik istnieje
   WriteLine($"Czy plik istnieje? {File.Exists(plikTekstowy)}");

   // utworzenie nowego pliku tekstowego
   // i wpisanie do niego wiersza tekstu
   StreamWriter pisanieTekstu = File.CreateText(plikTekstowy);
   pisanieTekstu.WriteLine("Witaj, C#!");
   pisanieTekstu.Close(); // zamknięcie pliku i zwolnienie zasobów
   WriteLine($"Czy plik istnieje? {File.Exists(plikTekstowy)}");

   // skopiowanie pliku, z nadpisaniem, jeżeli plik już istnieje
   File.Copy(sourceFileName: plikTekstowy,
      destFileName: plikKopiaZapasowa,
      overwrite: true);
   WriteLine($"Czy {plikKopiaZapasowa} istnieje? {File.Exists(plikKopiaZapasowa)}");
   Write("Sprawdź, czy plik istnieje, i naciśnij klawisz ENTER: ");
   ReadLine();

   // usunięcie pliku
   File.Delete(plikTekstowy);
   WriteLine($"Czy plik istnieje? {File.Exists(plikTekstowy)}");

   // odczytanie tekstu z pliku kopii zapasowej
   WriteLine($"Czytam zawartość pliku {plikKopiaZapasowa}:");
   StreamReader czytaniePliku = File.OpenText(plikKopiaZapasowa);
   WriteLine(czytaniePliku.ReadToEnd());
   czytaniePliku.Close();
}
