﻿using static System.Console;

string[] zespol1 = new[]
  { "Rafał", "Grzegorz", "Jan", "Gabrysia" };

string[] zespol2 = new[]
  { "Jacek", "Stefan", "Daniel", "Jacek", "Janina" };

string[] zespol3 = new[]
  { "Darek", "Jacek", "Jacek", "Malina", "Celina" };

Wyjscie(zespol1, "Zespół 1");
Wyjscie(zespol2, "Zespół 2");
Wyjscie(zespol3, "Zespół 3");

Wyjscie(zespol2.Distinct(), "zespol2.Distinct():");
Wyjscie(zespol2.DistinctBy(imie => imie.Substring(0, 2)),
  " zespol2.DistinctBy(imie => imie.Substring(0, 2)):");
Wyjscie(zespol2.Union(zespol3), "zespol2.Union(zespol3):");
Wyjscie(zespol2.Concat(zespol3), "zespol2.Concat(zespol3):");
Wyjscie(zespol2.Intersect(zespol3), "zespol2.Intersect(zespol3):");
Wyjscie(zespol2.Except(zespol3), "zespol2.Except(zespol3):");
Wyjscie(zespol1.Zip(zespol2, (c1, c2) => $"{c1} przeciw {c2}"),
  "zespol1.Zip(zespol2):");

static void Wyjscie(IEnumerable<string> zespol, string opis = "")
{
   if (!string.IsNullOrEmpty(opis))
   {
      WriteLine(opis);
   }
   Write(" ");
   WriteLine(string.Join(", ", zespol.ToArray()));
   WriteLine();
}
