﻿using static System.Console;

// Tablica typu string jest sekwencją implementującą interfejs IEnumerable<string>
string[] imiona = new[] { "Michał", "Pamela", "Jan", "Darek",
  "Agnieszka", "Kuba", "Tomek", "Celina" };

WriteLine("Opóźnione wykonanie");

// Pytanie: Które imiona kończą się na K?
// (zapisane za pomocą metody rozszerzającej LINQ)
var zapytanie1 = imiona.Where(imie => imie.EndsWith("k"));

// Pytanie: Które imiona kończą się na K?
// (zapisane za pomocą rozszerzonej składni LINQ)
var zapytanie2 = from imie in imiona where imie.EndsWith("k") select imie;

// Odpowiedź jako tablica ciągów znaków z wartościami Darek i Tomek
string[] wynik1 = zapytanie1.ToArray();

// Odpowiedź jako lista ciągów znaków z wartościami Darek i Tomek
List<string> wynik2 = zapytanie2.ToList();

// Odpowiedź jest zwracana w trakcie iterowania po wynikach
foreach (string imie in zapytanie1)
{
   WriteLine(imie); // Wypisuje Darek
   imiona[6] = "Tomasz"; // Zmienia Tomek na Tomasz
                         // W drugiej iteracji imię Tomasz nie kończy się literą K
}

WriteLine("Pisanie zapytań");

// var zapytanie = names.Where(
//   new Func<string, bool>(ImionaDluzszeNizCztery));

// var zapytanie = names.Where(ImionaDluzszeNizCztery);

IOrderedEnumerable<string> zapytanie = imiona
  .Where(imie => imie.Length > 4)
  .OrderBy(imie => imie.Length)
  .ThenBy(imie => imie);

foreach (string element in zapytanie)
{
   WriteLine(element);
}

WriteLine("Filtrowanie według typu");

List<Exception> wyjatki = new()
{
  new ArgumentException(),
  new SystemException(),
  new IndexOutOfRangeException(),
  new InvalidOperationException(),
  new NullReferenceException(),
  new InvalidCastException(),
  new OverflowException(),
  new DivideByZeroException(),
  new ApplicationException()
};

IEnumerable<ArithmeticException> wyjatkiArytmetyczne =
  wyjatki.OfType<ArithmeticException>();

foreach (ArithmeticException wyjatek in wyjatkiArytmetyczne)
{
   WriteLine(wyjatek);
}

static bool ImionaDluzszeNizCztery(string imie)
{
   return imie.Length > 4;
}

