﻿using System; // String
using System.Xml.Linq; // XDocument
using BibliotekaWspolna;
using DialectSoftware.Collections;
using DialectSoftware.Collections.Generics;

using static System.Console;

XDocument doc = new();

string s1 = "Witaj,";
String s2 = "świecie";

WriteLine($"{s1} {s2}");

// Liczby całkowite właściwe dla systemu

nint liczbaCalkowita = default;
IntPtr wskaznik = default;

WriteLine($"liczbaCalkowita = {liczbaCalkowita}");
WriteLine($"wskaznik = {wskaznik}");

WriteLine($"int.MaxValue = {int.MaxValue:N0}");
WriteLine($"nint.MaxValue = {nint.MaxValue:N0}");

// testowanie pakietu biblioteki klas

Write("Podaj szesnastkowo wartość koloru: ");
string? hex = ReadLine(); // lub "00ffc8"
WriteLine("Czy {0} jest poprawną wartością koloru? {1}",
  arg0: hex, arg1: hex.LiczbaSzesnastkowa());

Write("Podaj element XML: ");
string? znacznikXml = ReadLine(); // lub "<h1 class=\"<\" />"
WriteLine("Czy {0} jest poprawnym znacznikiem XML? {1}",
  arg0: znacznikXml, arg1: znacznikXml.PoprawnyZnacznikXML());

Write("Podaj hasło: ");
string? haslo = ReadLine(); // lub "sekret"
WriteLine("Czy {0} jest poprawnym hasłem? {1}",
  arg0: haslo, arg1: haslo.PoprawneHaslo());

// Używanie bibliotek spoza .NET Standard

Axis x = new("x", 0, 10, 1);
Axis y = new("y", 0, 4, 1);

Matrix<long> macierz = new(new[] { x, y });

for (int i = 0; i < macierz.Axes[0].Points.Length; i++)
{
  macierz.Axes[0].Points[i].Label = "x" + i.ToString();
}

for (int i = 0; i < macierz.Axes[1].Points.Length; i++)
{
  macierz.Axes[1].Points[i].Label = "y" + i.ToString();
}

foreach (long[] c in macierz)
{
  macierz[c] = c[0] + c[1];
}

foreach (long[] c in macierz)
{
  WriteLine("{0},{1} ({2},{3}) = {4}",
    macierz.Axes[0].Points[c[0]].Label,
    macierz.Axes[1].Points[c[1]].Label,
    c[0], c[1], macierz[c]);
}
