//---------------------------------------------------------------------------
//	fprog18.cpp	(okno gwne)
//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "fprog18.h"
#include "fprog18_2.h"
#include "fprog18_3.h"
//---------------------------------------------------------------------------
#pragma link "Grids"
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------
//	Algorytmy obiektu TPlansza
//---------------------------------------------------------
//	Konstruktor.
//	W Builderze kady obiekt ma konstruktora domylnego,
//	ktry potrafi przydzieli pami pod proste zmienne.
//	Ale tutaj mamy co ekstra - dwuwymiarow tablic...
TPlansza :: TPlansza( int Aszer, int Awys)
{
 szer = Aszer;
 wys = Awys;
 dane = new int *[ wys];				//wykreowanie 'wys' pustych wierszy

 for( int i = 0; i < wys; i ++)	//wykreowanie 'szer' oczek w kadym wierszu
 	dane[ i] = new int[ szer];
}
//---------------------------------------------------------
//	Destruktor.
TPlansza :: ~TPlansza( void)
{
 for( int i = 0; i < wys; i ++)	//usunicie 'szer' oczek z kadego wiersza
 	delete[] dane[ i];

 delete[] dane;							//usunicie 'wys' ju pustych wierszy
}
//---------------------------------------------------------
//	Wyczyszczenie planszy.
void TPlansza :: wyczysc( void)
{
 for( int i = 0; i < szer; i ++)
	for( int j = 0; j < wys; j ++)
	  	dane[ j][ i] = 0;				//nie ma ycia
}
//---------------------------------------------------------------------------
//	Algorytmy obiektu TForm1
//---------------------------------------------------------------------------
//	Konstruktor.
__fastcall TForm1::TForm1(TComponent* Owner) : TForm(Owner)
{
//	Mona tu umieci kod z funkcji FormCreate(), ale Borland zdaje si
//	preferowa umieszczanie algorytmw w funkcjach - reakcjach
//	na zdarzenia. FormCreate() jest reakcj na zdarzenie OnCreate.
}
//---------------------------------------------------------------------------
//	Reakcja na zdarzenie OnCreate - gdy forma jest tworzona -
//	jest 'przedueniem' konstruktora.
//	Tworzy si tu plansza i inicjuje ycie.
//	Dopasowuje si te rozmiar gridu do planszy.
void __fastcall TForm1::FormCreate(TObject *Sender)
{
 Plansza = new TPlansza( 19, 15);	//wywouje konstruktora z TPlansza
 Plansza -> wyczysc();				//nie ma ycia
 int x0 = Plansza -> szer/2;		//rodek planszy
 int y0 = Plansza -> wys/2;
 Plansza -> dane[ y0][ x0] =		//w rodku niech bdzie troch ycia
 Plansza -> dane[ y0][ x0 - 1] = Plansza -> dane[ y0][ x0 + 1] =
 Plansza -> dane[ y0 - 1][ x0] = Plansza -> dane[ y0 + 1][ x0] = true;

 DrawGrid1 -> ColCount = Plansza -> szer;	//uzgodnienie rozmiarw gridu i planszy
 DrawGrid1 -> RowCount = Plansza -> wys;
}
//---------------------------------------------------------------------------
//	Reakcja na zdarzenie OnDestroy - gdy forma jest likwidowana.
//	Funkcja FormDestroy() minimalnie wyprzedza dojcie do gosu
//	destruktora formy. Szczeglnie nadaje si do likwidacji
//	obiektu Plansza.
void __fastcall TForm1::FormDestroy(TObject *Sender)
{
 delete Plansza;						//wywouje destruktora z TPlansza
}
//---------------------------------------------------------------------------
//	Reakcja na zdarzenie OnDrawCell - gdy powstaje rysunek w oczku gridu.
//	Utworzenie rysunku w oczku gridu (tutaj elisy o kolorze zalenym od
//	stanu oczka planszy).
void __fastcall TForm1::DrawGrid1DrawCell( TObject *Sender, long Col, long Row,
	TRect &Rect, TGridDrawState State)
{
 DrawGrid1 -> Canvas -> Brush -> Color = Plansza -> dane[ Row][ Col] ? clYellow : clBlue;
 DrawGrid1 -> Canvas -> Ellipse( Rect.Left + 1, Rect.Top + 1, Rect.Right - 1, Rect.Bottom - 1);
}
//---------------------------------------------------------------------------
//	Reakcja na zdarzenie OnMouseDown - gdy dunito myszk.
void __fastcall TForm1::DrawGrid1MouseDown(TObject *Sender, TMouseButton Button,
	TShiftState Shift, int X, int Y)
{
 long r, c;
 DrawGrid1 -> MouseToCell( X, Y, c, r);		//w ktr komrk?
 Plansza -> dane[ r][ c] = Plansza -> dane[ r][ c] == 1 ? 0 : 1;	//negacja
}
//---------------------------------------------------------------------------
//	Wyczyszczenie planszy.
void __fastcall TForm1::Wyczyplansz1Click(TObject *Sender)
{
 Plansza -> wyczysc();
 DrawGrid1 -> Refresh();
}
//---------------------------------------------------------------------------
//	Ewolucja.
//	Naley j prowadzi na identycznej planszy pomocniczej.
void __fastcall TForm1::Jednopokolenie1Click(TObject *Sender)
{
 TPlansza *temp_plansza = new TPlansza( Plansza -> szer, Plansza -> wys);
 int i, j, il_sasiad;					//liczba ywych ssiadw

 temp_plansza -> wyczysc();			//plansza pomocnicza
 for( i = 1; i < Plansza -> szer - 1; i ++)	//marginesy pomijamy
 {
	for( j = 1; j < Plansza -> wys - 1; j ++)
    {
    	il_sasiad = Plansza -> dane[ j - 1][ i - 1] +
			       Plansza -> dane[ j - 1][ i] +
			       Plansza -> dane[ j - 1][ i + 1] +
			       Plansza -> dane[ j][ i - 1] +
			       Plansza -> dane[ j][ i] +
			       Plansza -> dane[ j][ i + 1] +
			       Plansza -> dane[ j + 1][ i - 1] +
			       Plansza -> dane[ j + 1][ i] +
			       Plansza -> dane[ j + 1][ i + 1];
       if( Plansza -> dane[ j][ i])		//Komrka ywa umiera
											//z samotnoci lub z przeludnienia
       {
       	if( il_sasiad < Form2 -> SpinEdit4 -> Value ||
       		il_sasiad > Form2 -> SpinEdit5 -> Value)
          	temp_plansza -> dane[ j][ i] = 0;
          else
          	temp_plansza -> dane[ j][ i] = 1;
       }
       else								//komrka martwa oywa,
											//gdy nie jest za ciasno
											//i jest dostatecznie wielu rodzicw
       {
       	if( il_sasiad <= Form2 -> SpinEdit6 -> Value &&
       		il_sasiad >= Form2 -> SpinEdit7 -> Value)
          	temp_plansza -> dane[ j][ i] = 1;
          else
          	temp_plansza -> dane[ j][ i] = 0;
       }
    }
 }
											//przeniesienie obrazu z planszy pomocn.
 for( int i = 0; i < Plansza -> szer; i ++)
	for( int j = 0; j < Plansza -> wys; j ++)
	  	Plansza -> dane[ j][ i] = temp_plansza -> dane[ j][ i];

 DrawGrid1 -> Refresh();				//odrysowanie nowej sytuacji
 delete temp_plansza;					//likwidacja planszy pomocniczej
}
//---------------------------------------------------------------------------
//	Zakoczenie programu.
void __fastcall TForm1::Koniec1Click(TObject *Sender)
{
 Close();
}
//---------------------------------------------------------------------------
//	Otwarcie okienka z parametrami.
void __fastcall TForm1::Parametry1Click(TObject *Sender)
{
 Form2 -> SpinEdit1 -> Value = Plansza -> szer;
 Form2 -> SpinEdit2 -> Value = Plansza -> wys;
 Form2 -> SpinEdit3 -> Value = DrawGrid1 -> DefaultRowHeight;

 if( Form2 -> ShowModal() == mrOk)//Zamknito przyciskiem OK?
 {
 	if( Plansza -> szer != Form2 -> SpinEdit1 -> Value ||
    	Plansza -> wys != Form2 -> SpinEdit2 -> Value)
    {										//Jeli zmieniono rozmiar planszy,
    	delete Plansza;				//naley j zbudowa na nowo
       Plansza = new TPlansza( Form2 -> SpinEdit1 -> Value, Form2 -> SpinEdit2 -> Value);
       Plansza -> wyczysc();
       DrawGrid1 -> ColCount = Form2 -> SpinEdit1 -> Value;
       DrawGrid1 -> RowCount = Form2 -> SpinEdit2 -> Value;
    }
    DrawGrid1 -> DefaultRowHeight = Form2 -> SpinEdit3 -> Value;
    DrawGrid1 -> DefaultColWidth  = Form2 -> SpinEdit3 -> Value;
	DrawGrid1 -> Refresh();			//odrysowanie nowej sytuacji
 }
}
//---------------------------------------------------------------------------
//	Otwarcie okienka informacyjnego.
void __fastcall TForm1::Informacje1Click(TObject *Sender)
{
 Form3 -> Show();
}
//---------------------------------------------------------------------------
