//---------------------------------------------------------------------------
//	fprog17.cpp	(okno gwne)
//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "fprog17.h"
#include "fprog17_2.h"
#include "fprog17_3.h"
#include "skala.h"
#include <math.h>			//ze wzgldu na funkcj sqrt() (pierwiastek)
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
//	Konstruktor inicjuje wartoci numeryczne
__fastcall TForm1::TForm1(TComponent* Owner) : TForm(Owner)
{
 M = 2.0e30;		//masa Soca
 x = 1.5e11;		//odlego Ziemia - Soce
 y = 0.0;		 	//Ziemia tak uoona, by nie byo wsprzdnej pionowej
 vx = 0.0;	 	//pozioma skadowa prdkoci orbitalnej Ziemi
 vy = 3.0e4;		//pionowa skadowa prdkoci orbitalnej Ziemi
 dt = 86400;	 	//doba = 60 x 60 x 24 sekund (modelowanie dobowe)
 il_krok = 364;	//tyle krokw o wielkoci dt to 1 rok
 szer = 4.0e11;	//zmieci si ukad Ziemia - Soce
 wys = 4.0e11;
}
//---------------------------------------------------------------------------
//	Odrysowanie treci okienka
void __fastcall TForm1::FormPaint(TObject *Sender)
{
 int i, xe, ye;						//wsprzdne ekranowe punktu
 double G = 6.67e-11;				//staa grawitacji
 double xx, yy, vxx, vyy;		//robocze wsprzdne i prdkoci
 double ax, ay;						//skadowe przyspieszenia
 double r, r2;						//odlego i jej kwadrat
 double a;							//pomocnicze
 TSkalowanie skala( 0, Panel1 -> Height, ClientWidth, ClientHeight - Panel1 -> Height,
						0.0, 0.0, szer, wys);

 xx = x;								//inicjowanie parametrw ruchu
 yy = y;
 vxx = vx;
 vyy = vy;
 for( i = 0; i < il_krok; i ++)//gwna ptla wyliczania trajektorii
 {
 	skala.get_ekr_wsp( xe, ye, xx, yy);
    Canvas -> Pixels[ xe][ ye] = clWhite;

    r2 = xx * xx + yy * yy;		//kwadrat odlegoci (tw. Pitagorasa)
    r = sqrt( r2);					//odlego
    a = -G * M / r / r2;			//parametr pomocniczy
    ax = a * xx;					//pozioma skadowa przyspieszenia grawitacyjnego
    ay = a * yy;					//poionowa skadowa przyspieszenia grawitacyjnego
    xx = xx + vxx * dt;			//nowe pooenie
    yy = yy + vyy * dt;
    vxx = vxx + ax * dt;			//nowa prdko
    vyy = vyy + ay * dt;
 }										//ukad wsprzdnych

 Canvas -> Pen -> Color = clYellow;
 i = ( Panel1 -> Height + ClientHeight) / 2;
 Canvas -> MoveTo( 0, i);		//linia pozioma
 Canvas -> LineTo( ClientWidth, i);
 i = ClientWidth / 2;				//linia pionowa
 Canvas -> MoveTo( i, Panel1 -> Height);
 Canvas -> LineTo( i, ClientHeight);
}
//---------------------------------------------------------------------------
//	Otwrz modalnie (wycznie) okno dialogowe, pytajce o parametry
void __fastcall TForm1::Parametry1Click(TObject *Sender)
{
 if( Form2 -> ShowModal() == mrOk)//czy zamknito przyciskiem OK?
 	Refresh();							//jeli tak, odrysuj ponownie grafik
}
//---------------------------------------------------------------------------
//	Otwrz niemodalnie (wspbienie) okienko informacyjne
void __fastcall TForm1::Informacje1Click(TObject *Sender)
{
 Form3 -> Show();
}
//---------------------------------------------------------------------------
//	Zamknij okno gwne, tzn, zakocz program
void __fastcall TForm1::Koniec1Click(TObject *Sender)
{
 Close();
}
//---------------------------------------------------------------------------
