//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "fprog10.h"
#include "skala.h"						//Obiekt TSkalowanie
#include <math.h>						//Funkcja sin()
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
//	Konstruktor
__fastcall TForm1::TForm1(TComponent* Owner) : TForm(Owner)
{
}
//---------------------------------------------------------------------------
//	Funkcja odpowiedzialna za grafik okienka
void __fastcall TForm1::FormPaint(TObject *Sender)
{
 kresl_bio_linie( 23, clRed);		//Sprawno fizyczna
 kresl_bio_linie( 28, clGreen);	//Emocje, wybuchowo
 kresl_bio_linie( 33, clBlue);		//Aktywno intelektualna
 nanies_podzialke();					//Dodatkowa kosmetyka wykresu
}
//---------------------------------------------------------------------------
//	Wykrelenie pojedynczej sinusoidy
void TForm1 :: kresl_bio_linie( int cykl, TColor kolor)
{
 int r, m, d, zakres;					//Dzie, mies i rok urodzenia
 d = atoi( Edit1 -> Text.c_str());
 m = atoi( Edit2 -> Text.c_str());
 r = atoi( Edit3 -> Text.c_str());
 zakres = atoi( Edit4 -> Text.c_str()) * 7;

 int i, xe_old, ye_old, xe, ye;
 bool pierwszy_punkt = true;
 TDateTime data_urodzenia( r, m, d);
 double il_dni_zycia = TDateTime().CurrentDate().Val - data_urodzenia.Val;
 TSkalowanie skal( Bevel1 -> Left + 2, Bevel1 -> Top + 2,
 						Bevel1 -> Width - 4, Bevel1 -> Height - 4,
                   il_dni_zycia, 0.0, 2.0 * zakres, 2.0);

 for( double nr = il_dni_zycia - zakres; nr <= il_dni_zycia + zakres; nr ++)
 {
	skal.get_ekr_wsp( xe, ye, nr, daj_bio_wartosc( cykl, nr));
    if( pierwszy_punkt)				//Pocztek wykresu?
    {
	   Canvas -> Pixels[ xe][ ye] = kolor;
       pierwszy_punkt = false;
    }
    else									//Kontynuacja linii wykresu
    {
		Canvas -> Pen -> Color = kolor;
	   Canvas -> MoveTo( xe_old, ye_old);
	   Canvas -> LineTo( xe, ye);
    }

   	xe_old = xe;
    ye_old = ye;
 }
}
//---------------------------------------------------------------------------
//	Warto sinusoidy o okresie 'cykl' w 'nr' dniu ycia.
//	Funkcja ma minimum (=-1) dla dnia nr=0.
double TForm1 :: daj_bio_wartosc( int cykl, double nr)
{
 return sin( 2. * M_PI * nr / (double)cykl - M_PI / 2.);
}
//---------------------------------------------------------------------------
//	Kosmetyka wykresu
void TForm1 :: nanies_podzialke( void)
{
 int xe, ye, z, zakres;
 zakres = atoi( Edit4 -> Text.c_str());
 TSkalowanie skal( Bevel1 -> Left + 1, Bevel1 -> Top + 1,
 						Bevel1 -> Width - 4, Bevel1 -> Height - 4,
                   0.0, 0.0, 2.0 * zakres, 2.0);
 Canvas -> Pen -> Color = clYellow;
 for( z = -zakres; z <= zakres; z++)			//linie pionowe
 {
 	skal.get_ekr_wsp( xe, ye, z, -1.0);
    Canvas -> MoveTo( xe, ye);
 	skal.get_ekr_wsp( xe, ye, z, 1.0);
    Canvas -> LineTo( xe, ye);
 }
 skal.get_ekr_wsp( xe, ye, -zakres, 0.0);	//linia pozioma
 Canvas -> MoveTo( xe, ye);
 skal.get_ekr_wsp( xe, ye, zakres, .0);
 Canvas -> LineTo( xe, ye);
}
//---------------------------------------------------------------------------
//	Nacinicie przycisku 'Rysuj'
void __fastcall TForm1::Button1Click(TObject *Sender)
{
 Refresh();
}
//---------------------------------------------------------------------------
//	Zareagowanie na interesujce klawisze (Enter i Esc)
void __fastcall TForm1::FormKeyPress(TObject *Sender, char &Key)
{
 if( Key == VK_RETURN)
 {
 	Refresh();                    //odwie grafik
    Key = 0;
 }
 else
 if( Key == VK_ESCAPE)
 {
 	Close();								//zakocz program
    Key = 0;
 }
}
//---------------------------------------------------------------------------
