//---------------------------------------------------------------------------
//	fprog16.cpp (okno gwne)
//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "fprog16.h"
#include "fprog16_2.h"
#include <math.h> 			//dopisane "rcznie" ze wzgl. na log() i fabs()
#include "Widmo.h"
//---------------------------------------------------------------------------
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
//	Konstruktor pierwszego okienka
__fastcall TForm1::TForm1(TComponent* Owner): TForm(Owner)
{
}
//---------------------------------------------------------------------------
//	Reakcja na nacinicie przycisku Licz
void __fastcall TForm1::SpeedButton1Click(TObject *Sender)
{
 Refresh();			//Ponownie odrysuj obraz
}
//---------------------------------------------------------------------------
//	Reakcja na nacinicie przycisku Info
void __fastcall TForm1::SpeedButton2Click(TObject *Sender)
{
 Form2 -> ShowModal();		//Uruchom okienko z wycznoci
// Form2 -> Show();			//wyprbuj te bez wycznoci!
}
//---------------------------------------------------------------------------
//	Reakcja na nacinicie przycisku Koniec
void __fastcall TForm1::SpeedButton3Click(TObject *Sender)
{
 Close();
}
//---------------------------------------------------------------------------
//	Odtworzenie grafiki
void __fastcall TForm1::FormPaint(TObject *Sender)
{
 int i, j, R, B, G;
 double wl, rxmin = 1.0, rxmax = 4.0, drx, rymin = 1.0, rymax = 4.0, dry;
 double lambda;
 TColor kolor;
 TWidmo widmo;

 drx = (rxmax - rxmin) / (double)(Bevel1 -> Width);
 dry = (rymax - rymin) / (double)(Bevel1 -> Height);

 rx = rxmin;
 for( i = Bevel1 -> Left; i < Bevel1 -> Width; i ++)
 {
 	ry = rymin;
	for( j = Bevel1 -> Top; j < Bevel1 -> Top + Bevel1 -> Height; j ++)
	{
       wl = wykladnik_Lapunowa();
       if( wl > 0)
       	kolor = clBlack;
       else
       {
       	lambda = widmo.LAMBDA_MIN - wl * widmo.LAMBDA_MAX / 10.;
       	widmo.lambda_to_RGB( R, G, B, 100, lambda);
       	kolor = (TColor)RGB( R, G, B);
       }
       Canvas -> Pixels[ i][ j] = kolor;
	  	ry += dry;
	}
    rx += drx;
 }
}
//---------------------------------------------------------------------------
//	Funkcja pomocnicza, liczca wykadnik L.
//	dla konkretnych zmiennych prywatnych rx, ry.
double TForm1 :: wykladnik_Lapunowa( void)
{
 int k, il_pokolen = 100, il_sum = 0;
 int il_sygnal = 5, sygnal_poz = 0, sygnal[] = {0, 0, 1, 1, 0};
 double N = 0.5, r, suma = 0.0, w;

 for( k = 0; k < il_pokolen; k ++)
 {
 	if( sygnal[ sygnal_poz] == 0)
    	r = rx;
    else
    	r = ry;
    sygnal_poz ++;
    if( sygnal_poz >= il_sygnal)
    	sygnal_poz = 0;
    N = N * r * (1. - N);
    w = fabs( r - 2. * N * r);
    if( w > 0)
    {
    	suma += log( w);
       il_sum ++;
    }
 }
 if( il_sum > 0)				//Ostronie: nie dziel przez zero
 	w = suma / (double) il_sum;
 else
 	w = 0;
 return w;
}
//---------------------------------------------------------------------------

