//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "widmo.h"
//---------------------------------------------------------------------------
//	Konstruktor
TWidmo :: TWidmo( void)
{
 int il_czysty_kolor = 15;			//liczba wej do tabeli tecza

 LAMBDA_MIN = 0.35E-6;				//granica nadfioletowa
 LAMBDA_MAX = 0.7E-6;					//granica podczerwona

 Askal = (double)(il_czysty_kolor) / (LAMBDA_MAX - LAMBDA_MIN);
 Bskal = -Askal * LAMBDA_MIN;

 Cskal = 4. / 100.;					//skalowanie jasnoci
}
//---------------------------------------------------------------------------
//	Najwaniejsza funkcja, zamieniajca L i jasno w amplitudy R, G, B
void TWidmo :: lambda_to_RGB( int &R, int &G, int &B, int jasnosc, double L)
{
 int pierwszy_kolor;
 double prawdziwy_kolor, ulamek_drugiego, a1, a2;
 double jasn;

 if( L <= LAMBDA_MIN || L >= LAMBDA_MAX)	//poza zakresem widzenia
 {
	R = G = B = 0;
	return;
 }

 if( jasnosc > 100)					//zbyt dua jasno
 	jasnosc = 100;
 if( jasnosc < 0)						//zbyt maa jasno
 	jasnosc = 0;

 jasn = Cskal * jasnosc;				//przeskalowanie jasnoci

 prawdziwy_kolor = Askal * L + Bskal;
 pierwszy_kolor = (int)prawdziwy_kolor;	//cz cakowita, np. 7
 ulamek_drugiego = prawdziwy_kolor - pierwszy_kolor;//uamek 2 koloru, np. 0.35

 a1 = tecza[ pierwszy_kolor][ 0] * jasn;
 a2 = tecza[ pierwszy_kolor + 1][ 0] * jasn;
 R = (int)( a1 + ulamek_drugiego * (a2 - a1));

 a1 = tecza[ pierwszy_kolor][ 1] * jasn;
 a2 = tecza[ pierwszy_kolor + 1][ 1] * jasn;
 G = (int)( a1 + ulamek_drugiego * (a2 - a1));

 a1 = tecza[ pierwszy_kolor][ 2] * jasn;
 a2 = tecza[ pierwszy_kolor + 1][ 2] * jasn;
 B = (int)( a1 + ulamek_drugiego * (a2 - a1));
}
//---------------------------------------------------------------------------

