//---------------------------------------------------------------------------
#include <vcl\vcl.h>
#pragma hdrstop

#include "skala.h"
//---------------------------------------------------------------------------
//	Konstruktor
TSkalowanie::TSkalowanie( int xe0, int ye0, int eszer, int ewys,
    					double xr0, double yr0, double rszer, double rwys)
{
 A = rszer / (double)eszer;						//z ekranu do przestrzeni
 B = xr0 - rszer / 2. - A * (double)xe0;
 C = -rwys / (double)ewys;
 D = yr0 + rwys  / 2. - C * (double)ye0;

 E = (double) eszer / rszer;					//z przestrzeni na ekran
 F = (double) xe0 - E * (xr0 - rszer / 2.);
 G = -(double)ewys  / rwys;
 H = (double) ye0 - G * (yr0 + rwys / 2.);
}
//---------------------------------------------------------------------------
//	Wyliczenie wsprzdnych rzeczywistych (x, y) punktu,
//	gdy znane s jego wsprzdne ekranowe (xe, ye).
void TSkalowanie::get_real_wsp( double &x, double &y, int xe, int ye)
{
 x = A * xe + B;
 y = C * ye + D;
}
//---------------------------------------------------------------------------
//	Wyliczenie wsprzdnych ekranowych (xe, ye) punktu,
//	gdy znane s jego wsprzdne rzeczywiste (x, y).
void TSkalowanie::get_ekr_wsp( int &xe, int &ye, double x, double y)
{
 xe = E * x + F;
 ye = G * y + H;
}
//---------------------------------------------------------------------------
