#!/bin/sh
#
############################################################################
#
# File:  /etc/fwsnort/fwsnort.sh
#
# Purpose:  This script was auto-generated by fwsnort, and implements
#           an iptables ruleset based upon Snort rules.  For more
#           information see the fwsnort man page or the documentation
#           available at http://www.cipherdyne.org/fwsnort/
#
# Generated with:     fwsnort --snort-sid 900001 --ipt-reject
# Generated on host:  minastirith
# Time stamp:         Wed Sep 19 00:58:55 2007
#
# Author:  Michael Rash <mbr@cipherdyne.org>
#
# Version: 1.0.1 (file revision: 393)
#
############################################################################
#

#==================== config ====================
ECHO=/bin/echo
IPTABLES=/sbin/iptables
#================== end config ==================


###
############ Create fwsnort iptables chains. ############
###
$IPTABLES -N FWSNORT_FORWARD 2> /dev/null
$IPTABLES -F FWSNORT_FORWARD

$IPTABLES -N FWSNORT_FORWARD_ESTAB 2> /dev/null
$IPTABLES -F FWSNORT_FORWARD_ESTAB

$IPTABLES -N FWSNORT_INPUT 2> /dev/null
$IPTABLES -F FWSNORT_INPUT

$IPTABLES -N FWSNORT_INPUT_ESTAB 2> /dev/null
$IPTABLES -F FWSNORT_INPUT_ESTAB

$IPTABLES -N FWSNORT_OUTPUT 2> /dev/null
$IPTABLES -F FWSNORT_OUTPUT

$IPTABLES -N FWSNORT_OUTPUT_ESTAB 2> /dev/null
$IPTABLES -F FWSNORT_OUTPUT_ESTAB


###
############ Add IP/network WHITELIST rules. ############
###
$IPTABLES -A FWSNORT_FORWARD -s 192.168.10.4 -j RETURN
$IPTABLES -A FWSNORT_FORWARD -d 192.168.10.4 -j RETURN
$IPTABLES -A FWSNORT_INPUT -s 192.168.10.4 -j RETURN
$IPTABLES -A FWSNORT_OUTPUT -d 192.168.10.4 -j RETURN

###
############ Add IP/network BLACKLIST rules. ############
###
$IPTABLES -A FWSNORT_FORWARD -s 192.168.10.203 -j DROP
$IPTABLES -A FWSNORT_FORWARD -d 192.168.10.203 -j DROP
$IPTABLES -A FWSNORT_INPUT -s 192.168.10.203 -j DROP
$IPTABLES -A FWSNORT_OUTPUT -d 192.168.10.203 -j DROP

###
############ Inspect ESTABLISHED tcp connections. ############
###
$IPTABLES -A FWSNORT_FORWARD -p tcp -m state --state ESTABLISHED -j FWSNORT_FORWARD_ESTAB
$IPTABLES -A FWSNORT_INPUT -p tcp -m state --state ESTABLISHED -j FWSNORT_INPUT_ESTAB
$IPTABLES -A FWSNORT_OUTPUT -p tcp -m state --state ESTABLISHED -j FWSNORT_OUTPUT_ESTAB

###
############ metasploit.rules ############
###
$ECHO "[+] Adding metasploit rules."

### alert tcp any 443 -> $HOME_NET any (msg:"Metasploit exploit DB update"; flow:established; content:"cacert@metasploit.com"; classtype:misc-activity; sid:900001; rev:1;)
$IPTABLES -A FWSNORT_FORWARD_ESTAB -d 192.168.10.0/24 -p tcp --sport 443 -m string --string "cacert@metasploit.com" --algo bm -m comment --comment "sid:900001; msg:Metasploit exploit DB update; classtype:misc-activity; rev:1; FWS:1.0.1;" -j LOG --log-ip-options --log-tcp-options --log-prefix "[1] REJ SID900001 ESTAB "
$IPTABLES -A FWSNORT_FORWARD_ESTAB -d 192.168.10.0/24 -p tcp --sport 443 -m string --string "cacert@metasploit.com" --algo bm -j REJECT --reject-with tcp-reset
$IPTABLES -A FWSNORT_INPUT_ESTAB -p tcp --sport 443 -m string --string "cacert@metasploit.com" --algo bm -m comment --comment "sid:900001; msg:Metasploit exploit DB update; classtype:misc-activity; rev:1; FWS:1.0.1;" -j LOG --log-ip-options --log-tcp-options --log-prefix "[1] REJ SID900001 ESTAB "
$IPTABLES -A FWSNORT_INPUT_ESTAB -p tcp --sport 443 -m string --string "cacert@metasploit.com" --algo bm -j REJECT --reject-with tcp-reset
$ECHO "    Rules added: 4"

###
############ Jump traffic to the fwsnort chains. ############
###
$IPTABLES -D FORWARD -i ! lo -j FWSNORT_FORWARD 2> /dev/null
$IPTABLES -I FORWARD 1 -i ! lo -j FWSNORT_FORWARD
$IPTABLES -D INPUT -i ! lo -j FWSNORT_INPUT 2> /dev/null
$IPTABLES -I INPUT 1 -i ! lo -j FWSNORT_INPUT
$IPTABLES -D OUTPUT -o ! lo -j FWSNORT_OUTPUT 2> /dev/null
$IPTABLES -I OUTPUT 1 -o ! lo -j FWSNORT_OUTPUT

$ECHO "[+] Finished."
### EOF ###
