#!/bin/sh
#
############################################################################
#
# File:  /etc/fwsnort/fwsnort.sh
#
# Purpose:  This script was auto-generated by fwsnort, and implements
#           an iptables ruleset based upon Snort rules.  For more
#           information see the fwsnort man page or the documentation
#           available at http://www.cipherdyne.org/fwsnort/
#
# Generated with:     fwsnort --snort-sid 1332,1336,1338,1339,1341,1342,1360
# Generated on host:  minastirith
# Time stamp:         Wed Sep 19 01:03:46 2007
#
# Author:  Michael Rash <mbr@cipherdyne.org>
#
# Version: 1.0.1 (file revision: 393)
#
############################################################################
#

#==================== config ====================
ECHO=/bin/echo
IPTABLES=/sbin/iptables
#================== end config ==================


###
############ Create fwsnort iptables chains. ############
###
$IPTABLES -N FWSNORT_FORWARD 2> /dev/null
$IPTABLES -F FWSNORT_FORWARD

$IPTABLES -N FWSNORT_FORWARD_ESTAB 2> /dev/null
$IPTABLES -F FWSNORT_FORWARD_ESTAB

$IPTABLES -N FWSNORT_INPUT 2> /dev/null
$IPTABLES -F FWSNORT_INPUT

$IPTABLES -N FWSNORT_INPUT_ESTAB 2> /dev/null
$IPTABLES -F FWSNORT_INPUT_ESTAB

$IPTABLES -N FWSNORT_OUTPUT 2> /dev/null
$IPTABLES -F FWSNORT_OUTPUT

$IPTABLES -N FWSNORT_OUTPUT_ESTAB 2> /dev/null
$IPTABLES -F FWSNORT_OUTPUT_ESTAB


###
############ Add IP/network WHITELIST rules. ############
###
$IPTABLES -A FWSNORT_FORWARD -s 192.168.10.4 -j RETURN
$IPTABLES -A FWSNORT_FORWARD -d 192.168.10.4 -j RETURN
$IPTABLES -A FWSNORT_INPUT -s 192.168.10.4 -j RETURN
$IPTABLES -A FWSNORT_OUTPUT -d 192.168.10.4 -j RETURN

###
############ Add IP/network BLACKLIST rules. ############
###
$IPTABLES -A FWSNORT_FORWARD -s 192.168.10.203 -j DROP
$IPTABLES -A FWSNORT_FORWARD -d 192.168.10.203 -j DROP
$IPTABLES -A FWSNORT_INPUT -s 192.168.10.203 -j DROP
$IPTABLES -A FWSNORT_OUTPUT -d 192.168.10.203 -j DROP

###
############ Inspect ESTABLISHED tcp connections. ############
###
$IPTABLES -A FWSNORT_FORWARD -p tcp -m state --state ESTABLISHED -j FWSNORT_FORWARD_ESTAB
$IPTABLES -A FWSNORT_INPUT -p tcp -m state --state ESTABLISHED -j FWSNORT_INPUT_ESTAB
$IPTABLES -A FWSNORT_OUTPUT -p tcp -m state --state ESTABLISHED -j FWSNORT_OUTPUT_ESTAB

###
############ web-attacks.rules ############
###
$ECHO "[+] Adding web-attacks rules."

### alert tcp $EXTERNAL_NET any -> $HTTP_SERVERS $HTTP_PORTS (msg:"WEB-ATTACKS /usr/bin/id command attempt"; flow:to_server,established; content:"/usr/bin/id"; nocase; classtype:web-application-attack; sid:1332; rev:5;)
$IPTABLES -A FWSNORT_FORWARD_ESTAB -d 192.168.10.0/24 -p tcp --dport 80 -m string --string "/usr/bin/id" --algo bm -m comment --comment "sid:1332; msg:WEB-ATTACKS /usr/bin/id command attempt; classtype:web-application-attack; rev:5; FWS:1.0.1;" -j LOG --log-ip-options --log-tcp-options --log-prefix "[1] SID1332 ESTAB "
$IPTABLES -A FWSNORT_INPUT_ESTAB -p tcp --dport 80 -m string --string "/usr/bin/id" --algo bm -m comment --comment "sid:1332; msg:WEB-ATTACKS /usr/bin/id command attempt; classtype:web-application-attack; rev:5; FWS:1.0.1;" -j LOG --log-ip-options --log-tcp-options --log-prefix "[1] SID1332 ESTAB "

### alert tcp $EXTERNAL_NET any -> $HTTP_SERVERS $HTTP_PORTS (msg:"WEB-ATTACKS chmod command attempt"; flow:to_server,established; content:"/bin/chmod"; nocase; classtype:web-application-attack; sid:1336; rev:5;)
$IPTABLES -A FWSNORT_FORWARD_ESTAB -d 192.168.10.0/24 -p tcp --dport 80 -m string --string "/bin/chmod" --algo bm -m comment --comment "sid:1336; msg:WEB-ATTACKS chmod command attempt; classtype:web-application-attack; rev:5; FWS:1.0.1;" -j LOG --log-ip-options --log-tcp-options --log-prefix "[2] SID1336 ESTAB "
$IPTABLES -A FWSNORT_INPUT_ESTAB -p tcp --dport 80 -m string --string "/bin/chmod" --algo bm -m comment --comment "sid:1336; msg:WEB-ATTACKS chmod command attempt; classtype:web-application-attack; rev:5; FWS:1.0.1;" -j LOG --log-ip-options --log-tcp-options --log-prefix "[2] SID1336 ESTAB "

### alert tcp $EXTERNAL_NET any -> $HTTP_SERVERS $HTTP_PORTS (msg:"WEB-ATTACKS chown command attempt"; flow:to_server,established; content:"/chown"; nocase; classtype:web-application-attack; sid:1338; rev:6;)
$IPTABLES -A FWSNORT_FORWARD_ESTAB -d 192.168.10.0/24 -p tcp --dport 80 -m string --string "/chown" --algo bm -m comment --comment "sid:1338; msg:WEB-ATTACKS chown command attempt; classtype:web-application-attack; rev:6; FWS:1.0.1;" -j LOG --log-ip-options --log-tcp-options --log-prefix "[3] SID1338 ESTAB "
$IPTABLES -A FWSNORT_INPUT_ESTAB -p tcp --dport 80 -m string --string "/chown" --algo bm -m comment --comment "sid:1338; msg:WEB-ATTACKS chown command attempt; classtype:web-application-attack; rev:6; FWS:1.0.1;" -j LOG --log-ip-options --log-tcp-options --log-prefix "[3] SID1338 ESTAB "

### alert tcp $EXTERNAL_NET any -> $HTTP_SERVERS $HTTP_PORTS (msg:"WEB-ATTACKS chsh command attempt"; flow:to_server,established; content:"/usr/bin/chsh"; nocase; classtype:web-application-attack; sid:1339; rev:5;)
$IPTABLES -A FWSNORT_FORWARD_ESTAB -d 192.168.10.0/24 -p tcp --dport 80 -m string --string "/usr/bin/chsh" --algo bm -m comment --comment "sid:1339; msg:WEB-ATTACKS chsh command attempt; classtype:web-application-attack; rev:5; FWS:1.0.1;" -j LOG --log-ip-options --log-tcp-options --log-prefix "[4] SID1339 ESTAB "
$IPTABLES -A FWSNORT_INPUT_ESTAB -p tcp --dport 80 -m string --string "/usr/bin/chsh" --algo bm -m comment --comment "sid:1339; msg:WEB-ATTACKS chsh command attempt; classtype:web-application-attack; rev:5; FWS:1.0.1;" -j LOG --log-ip-options --log-tcp-options --log-prefix "[4] SID1339 ESTAB "

### alert tcp $EXTERNAL_NET any -> $HTTP_SERVERS $HTTP_PORTS (msg:"WEB-ATTACKS /usr/bin/gcc command attempt"; flow:to_server,established; content:"/usr/bin/gcc"; nocase; classtype:web-application-attack; sid:1341; rev:5;)
$IPTABLES -A FWSNORT_FORWARD_ESTAB -d 192.168.10.0/24 -p tcp --dport 80 -m string --string "/usr/bin/gcc" --algo bm -m comment --comment "sid:1341; msg:WEB-ATTACKS /usr/bin/gcc command attempt; classtype:web-application-attack; rev:5; FWS:1.0.1;" -j LOG --log-ip-options --log-tcp-options --log-prefix "[5] SID1341 ESTAB "
$IPTABLES -A FWSNORT_INPUT_ESTAB -p tcp --dport 80 -m string --string "/usr/bin/gcc" --algo bm -m comment --comment "sid:1341; msg:WEB-ATTACKS /usr/bin/gcc command attempt; classtype:web-application-attack; rev:5; FWS:1.0.1;" -j LOG --log-ip-options --log-tcp-options --log-prefix "[5] SID1341 ESTAB "

### alert tcp $EXTERNAL_NET any -> $HTTP_SERVERS $HTTP_PORTS (msg:"WEB-ATTACKS gcc command attempt"; flow:to_server,established; content:"gcc%20-o"; nocase; classtype:web-application-attack; sid:1342; rev:5;)
$IPTABLES -A FWSNORT_FORWARD_ESTAB -d 192.168.10.0/24 -p tcp --dport 80 -m string --string "gcc%20-o" --algo bm -m comment --comment "sid:1342; msg:WEB-ATTACKS gcc command attempt; classtype:web-application-attack; rev:5; FWS:1.0.1;" -j LOG --log-ip-options --log-tcp-options --log-prefix "[6] SID1342 ESTAB "
$IPTABLES -A FWSNORT_INPUT_ESTAB -p tcp --dport 80 -m string --string "gcc%20-o" --algo bm -m comment --comment "sid:1342; msg:WEB-ATTACKS gcc command attempt; classtype:web-application-attack; rev:5; FWS:1.0.1;" -j LOG --log-ip-options --log-tcp-options --log-prefix "[6] SID1342 ESTAB "

### alert tcp $EXTERNAL_NET any -> $HTTP_SERVERS $HTTP_PORTS (msg:"WEB-ATTACKS netcat command attempt"; flow:to_server,established; content:"nc%20"; nocase; classtype:web-application-attack; sid:1360; rev:5;)
$IPTABLES -A FWSNORT_FORWARD_ESTAB -d 192.168.10.0/24 -p tcp --dport 80 -m string --string "nc%20" --algo bm -m comment --comment "sid:1360; msg:WEB-ATTACKS netcat command attempt; classtype:web-application-attack; rev:5; FWS:1.0.1;" -j LOG --log-ip-options --log-tcp-options --log-prefix "[7] SID1360 ESTAB "
$IPTABLES -A FWSNORT_INPUT_ESTAB -p tcp --dport 80 -m string --string "nc%20" --algo bm -m comment --comment "sid:1360; msg:WEB-ATTACKS netcat command attempt; classtype:web-application-attack; rev:5; FWS:1.0.1;" -j LOG --log-ip-options --log-tcp-options --log-prefix "[7] SID1360 ESTAB "
$ECHO "    Rules added: 14"

###
############ Jump traffic to the fwsnort chains. ############
###
$IPTABLES -D FORWARD -i ! lo -j FWSNORT_FORWARD 2> /dev/null
$IPTABLES -I FORWARD 1 -i ! lo -j FWSNORT_FORWARD
$IPTABLES -D INPUT -i ! lo -j FWSNORT_INPUT 2> /dev/null
$IPTABLES -I INPUT 1 -i ! lo -j FWSNORT_INPUT
$IPTABLES -D OUTPUT -o ! lo -j FWSNORT_OUTPUT 2> /dev/null
$IPTABLES -I OUTPUT 1 -o ! lo -j FWSNORT_OUTPUT

$ECHO "[+] Finished."
### EOF ###
