
# -*- coding: utf-8 -*-import socket
import os
import struct
import threading

from netaddr import IPNetwork,IPAddress
from ctypes import *

# host do nasuchiwania
host   = "192.168.0.187"

# docelowa podsie
subnet = "192.168.0.0/24"

# magiczna wiadomo, dla ktrej bdziemy sprawdza odpowiedzi ICMP
magic_message = "PYTHONRULES!"

def udp_sender(subnet,magic_message):
    sender = socket.socket(socket.AF_INET, socket.SOCK_DGRAM)
    
    for ip in IPNetwork(subnet):
        try:
            sender.sendto(magic_message,("%s" % ip,65212))
        except:
            pass
        
                
class IP(Structure):
    
    _fields_ = [
        ("ihl",           c_ubyte, 4),
        ("version",       c_ubyte, 4),
        ("tos",           c_ubyte),
        ("len",           c_ushort),
        ("id",            c_ushort),
        ("offset",        c_ushort),
        ("ttl",           c_ubyte),
        ("protocol_num",  c_ubyte),
        ("sum",           c_ushort),
        ("src",           c_ulong),
        ("dst",           c_ulong)
    ]
    
    def __new__(self, socket_buffer=None):
            return self.from_buffer_copy(socket_buffer)    
        
    def __init__(self, socket_buffer=None):

        # mapowanie staych protokow na ich nazwy
        self.protocol_map = {1:"ICMP", 6:"TCP", 17:"UDP"}
        
        # adresy IP czytelne dla czowieka
        self.src_address = socket.inet_ntoa(struct.pack("<L",self.src))
        self.dst_address = socket.inet_ntoa(struct.pack("<L",self.dst))
    
        # protok czytelny dla czowieka
        try:
            self.protocol = self.protocol_map[self.protocol_num]
        except:
            self.protocol = str(self.protocol_num)
            


class ICMP(Structure):
    
    _fields_ = [
        ("type",         c_ubyte),
        ("code",         c_ubyte),
        ("checksum",     c_ushort),
        ("unused",       c_ushort),
        ("next_hop_mtu", c_ushort)
        ]
    
    def __new__(self, socket_buffer):
        return self.from_buffer_copy(socket_buffer)    

    def __init__(self, socket_buffer):
        pass

# utworzenie surowego gniazda i zwizanie go z publicznym interfejsem
if os.name == "nt":
    socket_protocol = socket.IPPROTO_IP 
else:
    socket_protocol = socket.IPPROTO_ICMP
    
sniffer = socket.socket(socket.AF_INET, socket.SOCK_RAW, socket_protocol)

sniffer.bind((host, 0))

# chcemy przechwyci te nagwki IP
sniffer.setsockopt(socket.IPPROTO_IP, socket.IP_HDRINCL, 1)

# jeli uywany jest system Windows, musimy wysa kilka wywoa IOCTL,
# aby wczy tryb nieograniczony
if os.name == "nt":
    sniffer.ioctl(socket.SIO_RCVALL, socket.RCVALL_ON)


# rozpoczcie wysyania pakietw
t = threading.Thread(target=udp_sender,args=(subnet,magic_message))
t.start()        

try:
    while True:
        
        # wczytanie jednego pakietu
        raw_buffer = sniffer.recvfrom(65565)[0]
        
        # utworzenie nagwka IP z pierwszych 20 bajtw bufora
        ip_header = IP(raw_buffer[0:20])
      
        #drukuje "Protocol: %s %s -> %s" % (ip_header.protocol, ip_header.src_address, ip_header.dst_address)
    
        # jeli to ICMP, to bierzemy
        if ip_header.protocol == "ICMP":
            
            # obliczenie pocztku pakietu ICMP
            offset = ip_header.ihl * 4
            buf = raw_buffer[offset:offset + sizeof(ICMP)]
            
            # utworzenie struktury ICMP
            icmp_header = ICMP(buf)
            
            # drukuje "ICMP -> Type: %d Code: %d" % (icmp_header.type, icmp_header.code)

           
            if icmp_header.code == 3 and icmp_header.type == 3:
                
                # sprawdzenie czy otrzymalimy odpowied
                # mieszczc si w naszej podsieci
                if IPAddress(ip_header.src_address) in IPNetwork(subnet):
                    
                    # sprawdzenie naszej magicznej wiadomoci
                    if raw_buffer[len(raw_buffer)-len(magic_message):] == magic_message:
                        print "Host: %s" % ip_header.src_address
# obsuga skrtu CTRL+C
except KeyboardInterrupt:
    # jeli uywany jest system Windows, wyczamy tryb nieograniczony
    if os.name == "nt":
        sniffer.ioctl(socket.SIO_RCVALL, socket.RCVALL_OFF)

