/**
 * Metoda narzędziowa jQuery.fly
 * https://github.com/matjaz/jquery.fly
 *
 * Autor: Matjaž Lipuš (https://github.com/matjaz)
 */
(function($) {
    
    var fly  = $(),
        push = Array.prototype.push;
    
    $.fly = function(elem) {
        var len = fly.length,
            i;
        if ($.isArray(elem)) {
            fly.length  = 0;
            i           = push.apply(fly, elem);
        } else {
            if (elem instanceof $) {
                return elem;
            }
            if (typeof elem == "string") {
                throw "use jQuery()";
            }
            fly[0]     = elem;
            fly.length = i = 1;
        }
        // usuwanie "osieroconych" odwołań
        while (i<len) {
            delete fly[i++];
        }
        
        return fly;
    };
    
})(jQuery);
