var jqueryPromise = $.Deferred().resolve('Będę zgodny ze specyfikacją A+').promise();
var p = Promise.resolve(jqueryPromise);
p.then(function(result) {
    console.log(result);
});

// równoważne z:
var jqueryPromise = $.Deferred().resolve('Będę zgodny ze specyfikacją A+').promise();
var p = new Promise(function (resolve, reject) {
    jqueryPromise.then(resolve, reject);
});
p.then(function(result) {
    console.log(result);
});

// przykład transformacji za pomocą metody $.getJSON()
var aPlusAjaxPromise = Promise.resolve($.getJSON('AjaxContent.json'));
aPlusAjaxPromise.then(function(result) {
    console.log(result);
});


// ze specyfikacji A+ do postaci obiektu Promise biblioteki jQuery
var aPromise = Promise.resolve('Będę obiektem Promise biblioteki jQuery');
var p = $.Deferred(function (deferred) {
    aPromise.then(function(result) {
        return deferred.resolve(result);
    }, function(error) {
        return deferred.reject(error);
    });
}).promise();
p.then(function(result) {
    console.log(result);
});
