from bitcoin.rpc import RawProxy

p = RawProxy()

# Identyfikator transakcji Alice
txid = "0627052b6f28912f2703066a912ea577f2ce4da4caa5a5fbd8a57286c345c2f2"

# Najpierw pobierana jest nieprzetworzona transakcja w formacie szesnastkowym
raw_tx = p.getrawtransaction(txid)

# Transakcja w formacie szesnastkowym jest dekodowana do postaci obiektu w formacie JSON
decoded_tx = p.decoderawtransaction(raw_tx)

# Pobieranie wszystkich wyjść z transakcji
for output in decoded_tx['vout']:
    print(output['scriptPubKey']['addresses'], output['value'])
