#include <bitcoin/bitcoin.hpp>

// Szukany łańcuch znaków 
const std::string search = "1kid";

// Generowanie losowego tajnego klucza o 32 bajtach
bc::ec_secret random_secret(std::default_random_engine& engine);
// Tworzenie adresu bitcoin na podstawie tajnego klucza
std::string bitcoin_address(const bc::ec_secret& secret);
// Porównywanie z szukanym łańcuchem bez uwzględniania wielkości znaków
bool match_found(const std::string& address);

int main()
{
    // W Linuksie jako random_device używany jest generator "/dev/urandom"
    // UWAGA: w niektórych implementacjach ten generator może być niewystarczająco bezpieczny!
    // W rozwiązaniach produkcyjnych nie używaj adresów vanity wygenerowanych przez ten kod
    std::random_device random;
    std::default_random_engine engine(random());
    
    // Stale działająca pętla…
    while (true)
    {
        // Generowanie losowego tajnego klucza
        bc::ec_secret secret = random_secret(engine);
        // Ustalanie adresu
        std::string address = bitcoin_address(secret);
        // Czy adres pasuje do szukanego łańcucha znaków? (1kid)
        if (match_found(address))
        {
            // Powodzenie!
            std::cout << "Znaleziono adres vanity! " << address << std::endl;
            std::cout << "Tajny klucz: " << bc::hex(secret) << std::endl;
            return 0;
        }
    }
    // Kod nigdy nie powinien dotrzeć do tego miejsca!
    return 0;
}

bc::ec_secret random_secret(std::default_random_engine& engine)
{
    // Tworzenie nowego tajnego klucza
    bc::ec_secret secret;
    // Przypisywanie wartości losowych do kolejnych bajtów
    for (uint8_t& byte: secret)
        byte = engine() % std::numeric_limits<uint8_t>::max();
    // Zwracanie wyniku
    return secret;
}

std::string bitcoin_address(const bc::ec_secret& secret)
{
    // Przekształcanie tajnego klucza na adres używany do obsługi płatności
    bc::ec_point pubkey = bc::secret_to_public_key(secret);
    // Generowanie adresu
    bc::payment_address payaddr;
    bc::set_public_key(payaddr, pubkey);
    // Zwracanie danych w zakodowanej postaci
    return payaddr.encoded();
}

bool match_found(const std::string& address)
{
    auto addr_it = address.begin();
    // Porównywanie w pętli znaków szukanego łańcucha ze znakami 
    // podanego adresu (wielkie litery są przekształcane w małe)
    for (auto it = search.begin(); it != search.end(); ++it, ++addr_it)
        if (*it != std::tolower(*addr_it))
            return false;
    // Dojście do końca szukanego łańcucha, więc adresy pasują do siebie
    return true;
}

