#include <bitcoin/bitcoin.hpp>

int main()
{
    // Nieujawniany klucz prywatny.
    bc::ec_secret secret;
    bool success = bc::decode_base16(secret,
        "038109007313a5807b2eccc082c8c3fbb988a973cacf1a7df9ce725c31b14776");
    assert(success);
    // Pobieranie klucza publicznego.
    bc::ec_point public_key = bc::secret_to_public_key(secret);
    std::cout << "Klucz publiczny: " << bc::encode_hex(public_key) << std::endl;

    // Tworzenie adresu bitcoin.
    // Standardowo możesz posłużyć się takim kodem:
    //   bc::payment_address payaddr;
    //   bc::set_public_key(payaddr, public_key);
    //   const std::string address = payaddr.encoded();
	
	// Obliczanie skrótu klucza publicznego na potrzeby adresu P2PKH.
    const bc::short_hash hash = bc::bitcoin_short_hash(public_key);

    bc::data_chunk unencoded_address;
    // Rezerwowanie 25 bajtów
    //   [ wersja:1  ]
    //   [ skrót:20    ]
    //   [ suma kontrolna:4 ]
    unencoded_address.reserve(25);
    // Bajty wersji; 0 oznacza normalny adres bitcoin (P2PKH).
    unencoded_address.push_back(0);
    // Haszowanie danych
    bc::extend_data(unencoded_address, hash);
    // Suma kontrolna jest obliczana w wyniku haszowania danych i dodawania 4 bajtów skrótu.
    bc::append_checksum(unencoded_address);
    // W ostatnim kroku trzeba zakodować wynik za pomocą kodowania base58.
    assert(unencoded_address.size() == 25);
    const std::string address = bc::encode_base58(unencoded_address);

    std::cout << "Adres: " << address << std::endl;
    return 0;
}

