from cryptography.fernet import Fernet
from cryptography.hazmat.backends import default_backend
from cryptography.hazmat.primitives import hashes
from cryptography.hazmat.primitives.kdf.pbkdf2 import PBKDF2HMAC
import base64
import os

password = "hasło".encode("utf8")
salt = os.urandom(16)
pbkdf = PBKDF2HMAC(algorithm = hashes.SHA256(), length = 32, salt = salt, iterations = 100000, backend = default_backend())
key = pbkdf.derive(password)
pbkdf = PBKDF2HMAC(algorithm = hashes.SHA256(), length = 32, salt = salt, iterations = 100000, backend = default_backend())
#pbkdf.verify(password, key)
pbkdf.verify("Inne hasło".encode("utf8"), key)
key = base64.urlsafe_b64encode(key)
fernet = Fernet(key)
token = fernet.encrypt("Poufny komunikat".encode("utf8"))
print("Zaszyfrowany komunikat:", str(token))
print("Odszyfrowany komunikat:", str(fernet.decrypt(token).decode()))