import paramiko
import socket

# Dane serwera SSH.
host = 'localhost'
username = 'username'
password = 'password'
try:
    ssh_client = paramiko.SSHClient()
    # Włączenie wyświetlenia informacji diagnostycznych.
    paramiko.common.logging.basicConfig(level = paramiko.common.DEBUG)
    # Poniższy wiersz automatycznie dodaje klucz serwera do pliku knows_hosts.
    ssh_client.load_system_host_keys()
    #ssh_client.set_missing_host_key_policy(paramiko.AutoAddPolicy())
    response = ssh_client.connect(host, port = 22, username = username, password = password)
    print('Połączony na porcie nr 22', response)
    transport = ssh_client.get_transport()
    security_options = transport.get_security_options()
    print(security_options.kex)
    print(security_options.ciphers)
except paramiko.BadAuthenticationType as exception:
    print("BadAuthenticationException:", exception)
except paramiko.SSHException as sshException:
    print("SSHException:", sshException)
except socket.error as socketError:
    print("socketError:", socketError)
finally:
    print("Zamknięcie połączenia.")
    ssh_client.close()
    print("Połączenie zamknięte.")