import time
from stem import Signal
from stem.control import Controller
import requests

def get_tor_session():
    session = requests.session()
    session.proxies = {'http': 'socks5h://127.0.0.1:9050', 'https': 'socks5h://127.0.0.1:9050'}
    return session

def main():
    while True:
        time.sleep(5)
        print("Zmiana adresu IP")
        with Controller.from_port(port = 9051) as controller:
            controller.authenticate()
            controller.signal(Signal.NEWNYM)
        session = get_tor_session()
        print(session.get("http://httpbin.org/ip").text)

if __name__ == '__main__':
    main()