/**
     * Demonstracja uycia pakietu 
     * com.novell.ldap   
     * 
	 * @author Wiesaw Dudek
	 * @version 1.0
	 */

import com.novell.ldap.LDAPAttribute;
import com.novell.ldap.LDAPAttributeSet;
import com.novell.ldap.LDAPEntry;
import com.novell.ldap.LDAPConnection;
import com.novell.ldap.LDAPException;
import com.novell.ldap.LDAPModification;

import java.io.UnsupportedEncodingException;

public class LdapSample
{
    public static void main( String[] args )
    {
        ////////////////////////////////////
    	//USTAWIENIA ZMIENNYCH
    	////////////////////////////////////
    	
        int port = 389;
        int wersja  = LDAPConnection.LDAP_V3;

        String serwer = "localhost";
        String login  = "identyfikator=manager,miasto=krakow,kraj=pl";
        String haslo  = "manager";
        String wezel  = "miasto=krakow,kraj=pl";        
        
        LDAPConnection polaczenie = new LDAPConnection();
        
    	///////////////////////////////////
    	// TEST WSTAWIANIA WZA (DN)
    	///////////////////////////////////

        
        LDAPAttributeSet atrybuty = new LDAPAttributeSet();

        // tworzenie atrybutw dodawanego wza
        atrybuty.add( new LDAPAttribute( 
                             "objectclass", new String("osoba")));                
        atrybuty.add( new LDAPAttribute("imie", 
                new String[]{"Jan", "Piotr", "Zenon"}));               
        atrybuty.add( new LDAPAttribute("nazwisko", new String("Kurpa")));
        atrybuty.add( new LDAPAttribute("identyfikator", new String("kurpaj")));

        String  dodawanyWezel  = "identyfikator=kurpaj,"+wezel;      
        LDAPEntry nowyWezel = new LDAPEntry( dodawanyWezel, atrybuty );

        try {
        	
            // czenie z serwerem
            polaczenie.connect( serwer, port );
            
            // uwierzytelnienie
            polaczenie.bind( wersja, login, haslo.getBytes("UTF8") );
            
            // dodanie wza 
            polaczenie.add( nowyWezel );
            System.out.println( "\nWze dodany: " + dodawanyWezel );

            // rozczenie
            polaczenie.disconnect();
        }
        catch( LDAPException e ) {
            System.out.println( "Bd:  " + e.toString());
        }
        catch( UnsupportedEncodingException e ) {
            System.out.println( "Bd: " + e.toString() );
        }
        
        ///////////////////////////////////////
        //TEST MODYFIKOWANIA ATRYBUTW WZA
        ///////////////////////////////////////
        
        wezel=dodawanyWezel;
        try {
            // poczenie z serwerem
            polaczenie.connect( serwer, port);
            
            // uwierzytelnienie
            polaczenie.bind( wersja, login, haslo.getBytes("UTF8") );

            try {
                // dodanie atrybutu do wza

                LDAPModification[] dododania={new LDAPModification(LDAPModification.ADD, new LDAPAttribute( "wiek","20"))} ;                
            	
                polaczenie.modify( wezel, dododania);
                System.out.println("Dodano atrybut: wiek");
                
            } catch( LDAPException ex ) {
                if(ex.getResultCode()!=LDAPException.ATTRIBUTE_OR_VALUE_EXISTS){ 
                    System.out.println("Nie powiodo si dodanie atrybutu: " +
                                ex.toString());
                }                    
            }

          	LDAPModification[] dozmiany = {new LDAPModification(LDAPModification.REPLACE,new LDAPAttribute( "nazwisko",new String("Kowalski")))};            
            polaczenie.modify( wezel, dozmiany);
            System.out.println("Zmieniono atrybut");

            LDAPModification[] dousuniecia ={ new LDAPModification(LDAPModification.DELETE,new LDAPAttribute( "wiek"))};
            polaczenie.modify( wezel, dousuniecia);
            System.out.println("Usunito atrybut: wiek");

           // rozaczenie

            polaczenie.disconnect();
        }
        catch( LDAPException ex ) {
            if ( ex.getResultCode() == LDAPException.NO_SUCH_OBJECT )
               System.err.println( "Bd: Brak wza" );
            else if ( ex.getResultCode() ==
                                    LDAPException.INSUFFICIENT_ACCESS_RIGHTS )
               System.err.println( "Bd: niewystarczajce prawa dostpu" );
            else if ( ex.getResultCode() ==
                                       LDAPException.ATTRIBUTE_OR_VALUE_EXISTS )
               System.err.println( "Bd: Atrybut lub warto istnieje" );
            else {
               System.err.println( "Bd: " + ex.toString() );
            }       
            System.exit(1);
        }   
        catch( UnsupportedEncodingException ex ) {
            System.out.println( "Bd: " + ex.toString() );
        }     

        /////////////////////////////
        //TEST USUWANIA WZA
        /////////////////////////////
        
        LDAPConnection lc = new LDAPConnection();

        try {
           // czenie z serwerem
            lc.connect( serwer, port );
            
           // uwierzytelnienie
            lc.bind( wersja, login, haslo.getBytes("UTF8") );

           // usunicie wza
            lc.delete( wezel );
            System.out.println( "\nWze: " + wezel + " usunity." );

           // rozczenie

            lc.disconnect();
        }
        catch( LDAPException e ) {
            if ( e.getResultCode() == LDAPException.NO_SUCH_OBJECT )
               System.err.println( "Bd: Wze nieistnieje" );
            else if ( e.getResultCode() ==
                              LDAPException.INSUFFICIENT_ACCESS_RIGHTS )
                    System.err.println( "Bd: Niewystarczajce prawa" );
                 else
                    System.err.println( "Bd: " + e.toString() );
        }        
        catch( UnsupportedEncodingException e ) {
            System.out.println( "Bd: " + e.toString() );
        }

        
        System.exit(0);
    }
}
