/**
     * Demonstracja uycia pakietu JDBC-LDAP 
     * com.octetstring.jdbcLdap
     * 
	 * @author Wiesaw Dudek
	 * @version 1.0
	 */


import java.sql.*;

public class LdapBridgeSample {

	public static void main(String[] args) throws Exception {
		Class.forName("com.octetstring.jdbcLdap.sql.JdbcLdapDriver");

		// jdbc:ldap://serwer[:port]/bazowydn - gdzie bazowydn jest bazowym DN, 
		// od ktrego bd podawane nazwy DN w poleceniach SQL   
		java.sql.Connection polaczenie =
			DriverManager.getConnection(
				"jdbc:ldap://127.0.0.1:389/miasto=krakow,kraj=pl?SEARCH_SCOPE:=subTreeScope",
				"identyfikator=manager,miasto=krakow,kraj=pl",
				"manager");
		
		System.out.println("Poczono z serwerem LDAP");

        ///////////////////////////////
		// TEST WSTAWIANIA WZA (DN)
		///////////////////////////////
		
		try {
			Statement zapytanie = polaczenie.createStatement();
			int ilosc;
			ilosc =	zapytanie.executeUpdate(
					"INSERT INTO dzielnica=grzegorzki (objectClass,dzielnica) VALUES (rejon,grzegorzki)");
			ilosc += zapytanie.executeUpdate(
					"INSERT INTO identyfikator=robakw,dzielnica=grzegorzki (objectClass,identyfikator,nazwisko,imie) VALUES (osoba,robakw,Robak,Wieslaw)");			
			if (ilosc == 2) {
				System.out.println("Udane wprowadzanie danych za pomoc INSERT");
			} else {
				System.out.println("Wprowadzanie danych nie powiodo si");
			}
			zapytanie.close();
		} catch (Exception ex) {
			ex.printStackTrace();
		}
		
        ///////////////////////////////
		// TEST WYSZUKIWANIA WZW
		///////////////////////////////

		try {

			Statement zapytanie = polaczenie.createStatement();
			ResultSet wynik = zapytanie.executeQuery(
				"SELECT * FROM dzielnica=grzegorzki WHERE identyfikator=robakw");
			System.out.println("Liczba wierszy = " + wynik.getFetchSize());
			boolean jestWynik = false;
			while (wynik.next()) {
				jestWynik = true;

				System.out.println(
					"DN="
						+ wynik.getString("DN")
						+ ", imie="
						+ wynik.getString("imie")
						+ ", nazwisko="
						+ wynik.getString("nazwisko"));
			}
			if (!jestWynik)
				System.out.println("Polecenie SELECT nie zwrcio wierszy.");
		} catch (Exception ex) {
			ex.printStackTrace();
		}
		
        ///////////////////////////////
		// TEST USUWANIA WZW
		///////////////////////////////
		
		try {

			String SQL = "DELETE FROM dzielnica=grzegorzki WHERE nazwisko=?";
			PreparedStatement ps = polaczenie.prepareStatement(SQL);
			ps.setString(1, "Robak");
			ps.execute();

			System.out.println("Usuniecie wza za pomoc polecenia DELETE powiodo si");
		} catch (Exception e) {
			System.out.println("Usunicie wza nie powiodo si");
			e.printStackTrace();
		}
		
		
		polaczenie.close();
	}

}
