SET TERM ^;
CREATE PROCEDURE MOJAPROCEDURA 
(
  DATA_OD DATE,
  DATA_DO DATE
)
RETURNS
(
  OKRES_DATA_OD DATE,
  OKRES_DATA_DO DATE
)
AS
BEGIN
FOR
SELECT DISTINCT
Data+(mod(abs(EXTRACT(WEEKDAY FROM Data)-7),7)-2), 
Data+(mod(abs(EXTRACT(WEEKDAY FROM Data)-7),7)-2)+2 
FROM MojaTabela WHERE Data BETWEEN :DATA_OD AND :DATA_DO
AND EXTRACT(WEEKDAY FROM Data) IN (0,5,6)
INTO :OKRES_DATA_OD, :OKRES_DATA_DO 
DO SUSPEND ;
END^
COMMIT WORK^
SET TERM ;^

CREATE TABLE MOJATABELA(DATA DATE);
COMMIT WORK;
INSERT INTO MOJATABELA('2006-01-01');
INSERT INTO MOJATABELA('2006-01-20');
INSERT INTO MOJATABELA('2006-01-23');
COMMIT;
SELECT * FROM MOJATABELA('2006-01-01','2006-02-01');
