
	import java.io.IOException;

	import org.xml.sax.Attributes;
	import org.xml.sax.ContentHandler;
	import org.xml.sax.Locator;
	import org.xml.sax.SAXException;
	import org.xml.sax.XMLReader;

import org.apache.xerces.parsers.SAXParser;

	/**
     * XMLSAX przyjmuje ciek dostpu do pliku XML, ktry parsuje
     * za pomoc parsera DOM i wywietla sparsowan zawarto.   
     * 
	 * @author Wiesaw Dudek
	 * @version 1.0
	 */
	
	public class XMLSAX {

	    /**
	     * Wykonywane jest parsowanie pliku i wywietlanie zawartoci.
	     * 
	     * @param xml String cieka dostpu do pliku XML.
	     */
	    public void parseIt(String xml) {
	        System.out.println("Parsowanie pliku XML: " + xml + "\n\n");	    	
	        
	        // tworzymy procedury obsugi komunikatw parsera
	        ContentHandler myHandler = new MyContentHandler();
	        
	        try {
	            // adujemy parser
	            XMLReader parser = new SAXParser();
	                
	            // Zarejestruj procedur obsugi zawartoci.
	            parser.setContentHandler(myHandler);
	            
	            // parsujemy dokument
	            parser.parse(xml);
	            
	        } catch (IOException ex) {
	            System.out.println("Bd podczas odczytywania pliku XML: " + ex.getMessage());
	        } catch (SAXException ex) {
	            System.out.println("Bd podczas parsowania: " + ex.getMessage());
	        }
	            
	    }
	    
	    /**
	     * wejcie programu
	     */
	    public static void main(String[] args) {
	        if (args.length != 1) {
	            System.out.println("Uycie: java XMLSAX <cieka do pliku XML>");
	            System.exit(0);
	        }
	        
	        String xml = args[0];
	    
	        XMLSAX parserDemo = new XMLSAX();
	        parserDemo.parseIt(xml);
	    }
	}

	/**
	 * MyContentHandler implementuje interfejs SAX 
	 * ContentHandler i okrela sposb obsugi komunikatw parsera.
	 */
	class MyContentHandler implements ContentHandler {

	    /** 
	     * aktualna pozycja parsera  
	     */
	    private Locator pos;
	    
	    /**
	     * Ustawienie obiektu Locator do pniejszego wykorzystania 
	     *
	     * @param pos Locator obiekt umoliwiajcy uzyskanie informacji
	     * o miejscu parsowania
	     */
	    public void setDocumentLocator(Locator pos) {
	        System.out.println("ustawiono Locator");
	        this.pos = pos;	    	
	    }
	    
	    /**
	     * Wywoywana przed rozpoczciem parsowania
	     *  
	     * @throws SAXException 
	     */
	    public void startDocument() throws SAXException {
	        System.out.println("Rozpoczcie parsowania");	    	
	    }

	    /**
	     * Wywoana po zakoczeniu parsowania
	     * 
	     * @throws SAXException
	     */    
	    public void endDocument() throws SAXException {
	        System.out.println("Zakoczenie parsowania");	    	
	    }
	    
	    /**
	     * Natrafiono na instrukcj przetwarzania typu <?...
	     *
	     * @param object String obiekt docelowy instrukcji przetwarzania
	     * @param data <code>String</code> dane 
	     * @throws SAXException
	     */         
	    public void processingInstruction(String object, String data)
	        throws SAXException {
	        System.out.println("Instrukcja przetwarzania: Obiekt=" + object + "; Dane=" + data);	    	
	    }
	    
	    /**
	     *  Pocztek odwzorowania przestrzeni nazw. 
	     *  Pojawia si przed odwoniem do samego elementu.
	     *
	     * @param prefix String przedrostek przestrzeni nazw
	     * @param namespace String prestrze nazw
	     * @throws SAXException
	     */                  
	    public void startPrefixMapping(String prefix, String namespace) {
	        System.out.println("Pocztek odwzorowania dla przedrostka " + prefix + 
                    " odwzorowanego dla URI " +namespace);
	    	
	    }

	    /**
	     *  Koniec odwzorowania przedrostka
	     *
	     * @param prefix String przedrostek przestrzeni nazw
	     * @throws SAXException
	     */      
	    public void endPrefixMapping(String prefix) {
	        System.out.println("Koniec odwzorowania dla przedrostka " + prefix);
	    }
	    
	    /**
	     * Pocztek przetwarzania waciwego elementu. Przekazywane s atrybuty
	     * elementu poza: 
	     * xmlns:[prefix]
	     * xsi:schemaLocation
	     *
	     * @param namespace String przestrze nazw o ile istnieje
	     * @param name String nazwa elementu bez prefiksu przestrzeni nazw
	     * @param prefixName String [prefix]:[name].
	     * @param attribs Attributes atrybuty elementu
	     * @throws SAXException
	     */     
	    public void startElement(String namespace, String name,
	                             String prefixName, Attributes attribs)
	        throws SAXException {
	        System.out.print("pocztek elementu: " + name);
	        if (!namespace.equals("")) {
	            System.out.println(" w przestrzeni nazw " + namespace + 
	                               " (" + prefixName + ")");
	        } else {
	            System.out.println(" nie posiada skojarzonej przestrzeni nazw");
	        }

	        for (int i=0; i<attribs.getLength(); i++)
	            System.out.println("  Atrybut: " + attribs.getLocalName(i) +
	                               "=" + attribs.getValue(i));          
	    	
	    }
	    
	    /** 
	     * Parser dotar do koca elementu
	     * 
	     * @param namespace String przestrze nazw o ile istnieje
	     * @param name String nazwa elementu bez prefiksu przestrzeni nazw
	     * @param prefixName String [prefix]:[name]
	     * 
	     * @throws SAXException
	     */        
	    public void endElement(String namespace, String name, 
	                           String prefixName) 
	        throws SAXException {
	        System.out.println("koniec elementu: " + name + "\n");	    	
	    }
	    /**
	     * Dane tekstowe wewntrz elementu
	     *
	     * @param chars char[] znaki wewntrz elementu
	     * @param begin int indeks pocztku danych w tablicy chars
	     * @param end int indeks koca danych w tablicy chars
	     * @throws SAXException
	     */         
	    public void characters(char[] chars, int begin, int end) 
	        throws SAXException {
	    	
	        String str = new String(chars, begin, end);
	        System.out.println("tekst: " + str);

	    }

	    /**
	     * Parser informuje o znalezionych i zignorowanych biaych znakach 
	     * 
	     * @param chars char[] znaki wewntrz elementu
	     * @param begin int indeks pocztku danych w tablicy chars
	     * @param end int indeks koca danych w tablicy chars
	     * @throws SAXException
	     */
	    public void ignorableWhitespace(char[] chars, int begin, int end)
	        throws SAXException {
	    	
	        String str = new String(chars, begin, end);
	        System.out.println("zignorowane znaki: [" + str + "]");

	    }

	    /**
	     * Informacja o pominitej przez parser encji 
	     *
	     * @param name String nazwa encji
	     * @throws SAXException
	     */
	    public void skippedEntity(String name) throws SAXException {
	        System.out.println("Pominita encja: " + name);
	    }

	}
